/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.interfaces.SServiceInterfaceService;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.shared.interfaces.OAuthInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.RemoteServiceInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;

public abstract class AbstractBimServerClientFactory
implements BimServerClientFactory {
    private final SServicesMap servicesMap;
    private final MetaDataManager metaDataManager;
    private CloseableHttpClient httpClient;

    public AbstractBimServerClientFactory(SServicesMap servicesMap, MetaDataManager metaDataManager) {
        this.servicesMap = servicesMap;
        if (metaDataManager == null) {
            throw new IllegalArgumentException("MetaDataManager cannot be null");
        }
        this.metaDataManager = metaDataManager;
        this.initHttpClient();
    }

    public AbstractBimServerClientFactory(MetaDataManager metaDataManager) throws BimServerClientException {
        if (metaDataManager == null) {
            try {
                this.metaDataManager = new MetaDataManager(Files.createTempDirectory("bimserver-tmp", new FileAttribute[0]));
                this.metaDataManager.init();
            }
            catch (IOException e) {
                throw new BimServerClientException("Problem creating tmp directory");
            }
        } else {
            this.metaDataManager = metaDataManager;
        }
        this.servicesMap = new SServicesMap();
        SServiceInterfaceService serviceInterface = new SServiceInterfaceService(this.servicesMap, null, ServiceInterface.class);
        this.addService((SService)serviceInterface);
        this.addService(new SService(this.servicesMap, null, MetaInterface.class));
        this.addService(new SService(this.servicesMap, null, AdminInterface.class));
        this.addService(new SService(this.servicesMap, null, AuthInterface.class));
        this.addService(new SService(this.servicesMap, null, SettingsInterface.class));
        this.addService(new SService(this.servicesMap, null, PluginInterface.class));
        this.addService(new SService(this.servicesMap, null, NotificationInterface.class));
        this.addService(new SService(this.servicesMap, null, RemoteServiceInterface.class));
        this.addService(new SService(this.servicesMap, null, LowLevelInterface.class));
        this.addService(new SService(this.servicesMap, null, NotificationRegistryInterface.class));
        this.addService(new SService(this.servicesMap, null, OAuthInterface.class));
        this.servicesMap.initialize();
        this.initHttpClient();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void initHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        this.httpClient = builder.build();
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public BimServerClientInterface create() throws ServiceException, ChannelConnectionException {
        return this.create(null);
    }

    public void addService(SService sService) {
        this.servicesMap.add(sService);
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }
}

