/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.notifications;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.bimserver.client.notifications.NotificationsManager;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.pb.ReflectiveRpcChannel;
import org.bimserver.shared.pb.ServiceMethodNotFoundException;
import org.bimserver.shared.pb.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(Handler.class);
    private final Socket socket;
    private final ProtocolBuffersMetaData protocolBuffersMetaData;
    private final NotificationsManager socketNotificationsClient;
    private ServiceFactory serviceFactory;
    private boolean running;
    private final SServicesMap servicesMap;

    public Handler(NotificationsManager socketNotificationsClient, Socket socket, NotificationInterface notificationInterface, ProtocolBuffersMetaData protocolBuffersMetaData, SServicesMap servicesMap) {
        this.socketNotificationsClient = socketNotificationsClient;
        this.socket = socket;
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        this.servicesMap = servicesMap;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            DataInputStream dis = new DataInputStream(this.socket.getInputStream());
            String token = dis.readUTF();
            ReflectiveRpcChannel reflectiveRpcChannel = new ReflectiveRpcChannel(ServiceInterface.class, this.serviceFactory.get(token, AccessMethod.INTERNAL).get(ServiceInterface.class), this.protocolBuffersMetaData, this.servicesMap);
            while (this.running) {
                String serviceName = dis.readUTF();
                String methodName = dis.readUTF();
                try {
                    ProtocolBuffersMetaData.MethodDescriptorContainer methodDescriptorContainer = this.protocolBuffersMetaData.getMethod(serviceName, methodName);
                    DynamicMessage.Builder newBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)methodDescriptorContainer.getInputDescriptor());
                    newBuilder.mergeDelimitedFrom((InputStream)dis);
                    DynamicMessage request = newBuilder.build();
                    Message response = reflectiveRpcChannel.callBlockingMethod(methodDescriptorContainer, (Message)request);
                    response.writeDelimitedTo(this.socket.getOutputStream());
                }
                catch (ServiceNotFoundException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (ServiceMethodNotFoundException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.socketNotificationsClient.notifyDisconnect();
    }

    public void close() {
        this.running = false;
        this.interrupt();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

