/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bimserver.client.Channel;
import org.bimserver.shared.Token;
import org.bimserver.shared.TokenChangeListener;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.interfaces.PublicInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapChannel
extends Channel
implements TokenChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapChannel.class);
    private Client client;
    private boolean useSoapHeaderSessions;
    private String address;
    private Set<Class<? extends PublicInterface>> interfaces;

    public SoapChannel(CloseableHttpClient httpClient, String address, boolean useSoapHeaderSessions, Set<Class<? extends PublicInterface>> interfaces) {
        super(httpClient);
        this.address = address;
        this.useSoapHeaderSessions = useSoapHeaderSessions;
        this.interfaces = interfaces;
    }

    @Override
    public void connect(TokenHolder tokenHolder) {
        for (Class<? extends PublicInterface> interface1 : this.interfaces) {
            JaxWsProxyFactoryBean cpfb = new JaxWsProxyFactoryBean();
            cpfb.setServiceClass(interface1);
            cpfb.setAddress(this.address + "/" + interface1.getSimpleName());
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("mtom-enabled", Boolean.TRUE);
            cpfb.setProperties(properties);
            PublicInterface serviceInterface = (PublicInterface)cpfb.create();
            this.client = ClientProxy.getClient((Object)serviceInterface);
            HTTPConduit http = (HTTPConduit)this.client.getConduit();
            http.getClient().setConnectionTimeout(360000L);
            http.getClient().setAllowChunking(false);
            http.getClient().setReceiveTimeout(320000L);
            if (!this.useSoapHeaderSessions) {
                ((BindingProvider)serviceInterface).getRequestContext().put("javax.xml.ws.session.maintain", Boolean.TRUE);
            }
            this.add(interface1.getName(), serviceInterface);
        }
        tokenHolder.registerTokenChangeListener((TokenChangeListener)this);
        this.notifyOfConnect();
    }

    public void newToken(String token) {
        if (this.useSoapHeaderSessions) {
            for (PublicInterface p : this.getServiceInterfaces().values()) {
                ArrayList<Header> headers = new ArrayList<Header>();
                try {
                    Token tokenObject = new Token(token);
                    Header sessionHeader = new Header(new QName("uri:org.bimserver.shared", "token"), (Object)tokenObject, (DataBinding)new JAXBDataBinding(new Class[]{Token.class}));
                    headers.add(sessionHeader);
                }
                catch (JAXBException e) {
                    LOGGER.error("", (Throwable)e);
                }
                ((BindingProvider)p).getRequestContext().put(Header.HEADER_LIST, headers);
            }
        }
    }

    @Override
    public void disconnect() {
        this.client.destroy();
        this.notifyOfDisconnect();
    }
}

