/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.dictionary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.iai.ifcNamespaces.Namespace;
import org.iai.ifcNamespaces.NamespacesDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespaces {
    private static final Logger LOGGER = LoggerFactory.getLogger(Namespaces.class);
    private File nsConfFile;
    private NamespacesDocument ifcNamespaces;
    private boolean singleNamespace = false;
    private HashMap<String, List<String>> namespaces;
    private HashMap<String, String> EXPRESSnames = new HashMap();
    private String defaultNS = "";

    public Namespaces(String filename) {
        this.nsConfFile = new File(filename);
        this.namespaces = new HashMap();
        if (!this.nsConfFile.exists()) {
            System.out.println("no existing file provided, using '" + filename + "' as namespace");
            this.singleNamespace = true;
            this.defaultNS = filename;
            this.namespaces.put(filename, new ArrayList());
        }
    }

    public boolean readNSConfig() {
        if (this.nsConfFile.canRead() && !this.singleNamespace) {
            try {
                this.ifcNamespaces = NamespacesDocument.Factory.parse(this.nsConfFile);
                Namespace[] nsArray = this.ifcNamespaces.getNamespaces().getNamespaceArray();
                for (int i = 0; i < nsArray.length; ++i) {
                    Namespace ns = nsArray[i];
                    ArrayList<String> objects = new ArrayList<String>();
                    if (ns.getDefinedtypes() != null) {
                        objects.addAll(this.toStringList(ns.getDefinedtypes().getDefinedtypeArray()));
                    }
                    if (ns.getEntites() != null) {
                        objects.addAll(this.toStringList(ns.getEntites().getEntityArray()));
                    }
                    if (ns.getEnumerations() != null) {
                        objects.addAll(this.toStringList(ns.getEnumerations().getEnumerationArray()));
                    }
                    if (ns.getSelects() != null) {
                        objects.addAll(this.toStringList(ns.getSelects().getSelectArray()));
                    }
                    String nsName = ns.getName();
                    Iterator iter = objects.iterator();
                    while (iter.hasNext()) {
                        this.addNamespaceEntry((String)iter.next(), nsName);
                    }
                    this.namespaces.put(nsName, objects);
                }
                return true;
            }
            catch (XmlException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return false;
    }

    public String getNS(String objName) {
        if (this.singleNamespace) {
            return this.defaultNS;
        }
        return this.EXPRESSnames.get(objName);
    }

    private List<String> toStringList(String[] inArray) {
        ArrayList<String> sl = new ArrayList<String>();
        for (int i = 0; i < inArray.length; ++i) {
            sl.add(inArray[i]);
        }
        return sl;
    }

    public void addNamespaceEntry(String EXPRESSname, String namespace) {
        this.EXPRESSnames.put(EXPRESSname, namespace);
    }

    public Set<String> getNamespaces() {
        return this.namespaces.keySet();
    }
}

