/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public abstract class BaseTableReader<T>
implements ReleasableIterator<T> {
    private DatabaseContext dbCtx;
    private ResultSet resultSet;
    private T nextValue;

    public BaseTableReader(DatabaseLoginCredentials loginCredentials) {
        this.dbCtx = new DatabaseContext(loginCredentials);
    }

    protected abstract ResultSet createResultSet(DatabaseContext var1);

    protected abstract ReadResult<T> createNextValue(ResultSet var1);

    protected ReadResult<T> createLastValue() {
        return new ReadResult<Object>(true, null);
    }

    private void readNextValue() {
        if (this.resultSet == null) {
            this.resultSet = this.createResultSet(this.dbCtx);
        }
        try {
            ReadResult<T> readResult;
            while (!(readResult = this.resultSet.next() ? this.createNextValue(this.resultSet) : this.createLastValue()).isUsableResult()) {
            }
            this.nextValue = readResult.getEntity();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to move to next record.", (Throwable)e);
        }
    }

    public boolean hasNext() {
        if (this.resultSet == null) {
            this.readNextValue();
        }
        return this.nextValue != null;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextValue;
        this.readNextValue();
        return result;
    }

    public void close() {
        this.nextValue = null;
        this.resultSet = null;
        this.dbCtx.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected static class ReadResult<T> {
        private boolean usableResult;
        private T entity;

        public ReadResult(boolean usableResult, T entity) {
            this.usableResult = usableResult;
            this.entity = entity;
        }

        public boolean isUsableResult() {
            return this.usableResult;
        }

        public T getEntity() {
            return this.entity;
        }
    }
}

