/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ActionChangeWriter;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ChangeWriter;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;

public class ApidbChangeWriter
implements ChangeSink {
    private final ChangeWriter changeWriter;
    private final Map<ChangeAction, ActionChangeWriter> actionWriterMap;
    private final SchemaVersionValidator schemaVersionValidator;

    public ApidbChangeWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean populateCurrentTables) {
        this.changeWriter = new ChangeWriter(loginCredentials, populateCurrentTables);
        this.actionWriterMap = new HashMap<ChangeAction, ActionChangeWriter>();
        this.actionWriterMap.put(ChangeAction.Create, new ActionChangeWriter(this.changeWriter, ChangeAction.Create));
        this.actionWriterMap.put(ChangeAction.Modify, new ActionChangeWriter(this.changeWriter, ChangeAction.Modify));
        this.actionWriterMap.put(ChangeAction.Delete, new ActionChangeWriter(this.changeWriter, ChangeAction.Delete));
        this.schemaVersionValidator = new SchemaVersionValidator(loginCredentials, preferences);
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(ChangeContainer change) {
        this.schemaVersionValidator.validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
        ChangeAction action = change.getAction();
        if (!this.actionWriterMap.containsKey(action)) {
            throw new OsmosisRuntimeException("The action " + action + " is unrecognized.");
        }
        change.getEntityContainer().process((EntityProcessor)this.actionWriterMap.get(action));
    }

    public void complete() {
        this.changeWriter.complete();
    }

    public void close() {
        this.changeWriter.close();
    }
}

