/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import crosby.binary.osmosis.OsmosisSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkManager;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.osmbinary.file.BlockOutputStream;

public class OsmosisSerializerFactory
extends TaskManagerFactory {
    private static final String ARG_FILE_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "dump.osm.pbf";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        OsmosisSerializer task = null;
        String fileName = this.getStringArgument(taskConfig, ARG_FILE_NAME, this.getDefaultStringArgument(taskConfig, DEFAULT_FILE_NAME));
        File file = new File(fileName);
        try {
            BlockOutputStream output = new BlockOutputStream((OutputStream)new FileOutputStream(file));
            task = new OsmosisSerializer(output);
            task.configBatchLimit(this.getIntegerArgument(taskConfig, "batchlimit", 8000));
            task.configOmit(this.getBooleanArgument(taskConfig, "omitmetadata", false));
            task.setUseDense(this.getBooleanArgument(taskConfig, "usedense", true));
            task.configGranularity(this.getIntegerArgument(taskConfig, "granularity", 100));
            output.setCompress(this.getStringArgument(taskConfig, "compress", "deflate"));
        }
        catch (FileNotFoundException e) {
            throw new OsmosisRuntimeException("Failed to initialize Osmosis pbf serializer.", (Throwable)e);
        }
        return new SinkManager(taskConfig.getId(), (Sink)task, taskConfig.getPipeArgs());
    }
}

