/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import crosby.binary.file.BlockInputStream;
import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.osmosis.OsmosisBinaryParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class OsmosisReader
implements RunnableSource {
    private File pbfFile;
    private OsmosisBinaryParser parser;
    private Sink sink;

    public OsmosisReader(File pbfFile) {
        this.pbfFile = pbfFile;
        this.parser = new OsmosisBinaryParser();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
        this.parser.setSink(sink);
    }

    public void run() {
        try {
            this.sink.initialize(Collections.emptyMap());
            try (BlockInputStream blockInputStream = new BlockInputStream((InputStream)new FileInputStream(this.pbfFile), (BlockReaderAdapter)this.parser);){
                blockInputStream.process();
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process PBF stream", (Throwable)e);
        }
        finally {
            this.sink.close();
        }
    }
}

