/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6.impl;

import crosby.binary.Osmformat;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.BlobToBlockMapper;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlock;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.RawBlob;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.StreamSplitter;

public class HeaderSeeker
implements Function<StreamSplitter, Osmformat.HeaderBlock> {
    private BlobToBlockMapper blobToBlockMapper = new BlobToBlockMapper();

    @Override
    public Osmformat.HeaderBlock apply(StreamSplitter streamSplitter) {
        if (!streamSplitter.hasNext()) {
            throw new OsmosisRuntimeException("PBF stream ended before a header could be found.");
        }
        RawBlob rawBlob = streamSplitter.next();
        PbfBlock block = this.blobToBlockMapper.apply(rawBlob);
        Optional<Osmformat.HeaderBlock> optionalHeaderBlock = block.getHeaderBlock();
        if (!optionalHeaderBlock.isPresent()) {
            throw new OsmosisRuntimeException("A non header block was encountered in the PBF file first");
        }
        return optionalHeaderBlock.get();
    }
}

