/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class ReplicationSequenceFormatter {
    private NumberFormat sequenceFormat;

    public ReplicationSequenceFormatter(int minimumLength, int groupingLength) {
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.US);
        formatSymbols.setGroupingSeparator('/');
        StringBuilder formatString = new StringBuilder();
        for (int i = 0; i < minimumLength || i <= groupingLength; ++i) {
            if (i > 0 && groupingLength > 0 && i % groupingLength == 0) {
                formatString.append(',');
            }
            if (i < minimumLength) {
                formatString.append('0');
                continue;
            }
            formatString.append('#');
        }
        formatString.reverse();
        this.sequenceFormat = new DecimalFormat(formatString.toString(), formatSymbols);
    }

    public String getFormattedName(long sequenceNumber, String fileNameSuffix) {
        String fileName = this.sequenceFormat.format(sequenceNumber) + fileNameSuffix;
        return fileName;
    }
}

