/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxParserFactory {
    private SaxParserFactory() {
    }

    public static SAXParser createParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", (Throwable)e);
        }
    }

    private static void validate() {
        try {
            UnicodeTestHandler unicodeTestHandler = new UnicodeTestHandler();
            SAXParser parser = SaxParserFactory.createParser();
            InputStream is = SaxParserFactory.class.getResourceAsStream("test-unicode-node.osm");
            parser.parse(is, (DefaultHandler)unicodeTestHandler);
            if (!unicodeTestHandler.isCorrect()) {
                throw new OsmosisRuntimeException("SAX Parser doesn't correctly support multi-byte characters, try including a modern version of Xerces on the classpath.");
            }
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read unicode test file.", (Throwable)e);
        }
    }

    static {
        SaxParserFactory.validate();
    }

    private static class UnicodeTestHandler
    extends DefaultHandler {
        private static final String NAME_VALUE = "H\ud834\udd1eM Events";
        private boolean nameCorrect;
        private boolean enNameCorrect;

        private UnicodeTestHandler() {
        }

        private boolean validateNameValue(Attributes attributes) {
            return NAME_VALUE.equals(attributes.getValue("v"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("tag".equals(qName)) {
                if ("name".equals(attributes.getValue("k"))) {
                    if (this.validateNameValue(attributes)) {
                        this.nameCorrect = true;
                    }
                } else if ("name:en".equals(attributes.getValue("k")) && this.validateNameValue(attributes)) {
                    this.enNameCorrect = true;
                }
            }
        }

        public boolean isCorrect() {
            return this.nameCorrect && this.enNameCorrect;
        }
    }
}

