/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.Locale;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.xml.common.ElementWriter;

public class BoundWriter
extends ElementWriter {
    private boolean legacyBound;

    public BoundWriter(String elementName, int indentLevel, boolean legacyBound) {
        super(elementName, indentLevel);
        this.legacyBound = legacyBound;
    }

    public void process(Bound bound) {
        if (this.legacyBound) {
            this.processLegacy(bound);
        } else {
            this.processRegular(bound);
        }
    }

    private void processRegular(Bound bound) {
        String format = "%.5f";
        this.beginOpenElement();
        this.addAttribute("minlon", String.format(Locale.US, format, bound.getLeft()));
        this.addAttribute("minlat", String.format(Locale.US, format, bound.getBottom()));
        this.addAttribute("maxlon", String.format(Locale.US, format, bound.getRight()));
        this.addAttribute("maxlat", String.format(Locale.US, format, bound.getTop()));
        if (bound.getOrigin() != null) {
            this.addAttribute("origin", bound.getOrigin());
        }
        this.endOpenElement(true);
    }

    private void processLegacy(Bound bound) {
        if (!"".equals(bound.getOrigin())) {
            this.beginOpenElement();
            this.addAttribute("box", String.format(Locale.US, "%.5f,%.5f,%.5f,%.5f", bound.getBottom(), bound.getLeft(), bound.getTop(), bound.getRight()));
            this.addAttribute("origin", bound.getOrigin());
            this.endOpenElement(true);
        }
    }
}

