/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;

public class CompressionActivator {
    private CompressionMethod compressionMethod;

    public CompressionActivator(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public OutputStream createCompressionOutputStream(OutputStream destinationStream) {
        try {
            if (CompressionMethod.None.equals((Object)this.compressionMethod)) {
                return destinationStream;
            }
            if (CompressionMethod.GZip.equals((Object)this.compressionMethod)) {
                return new GZIPOutputStream(destinationStream);
            }
            if (CompressionMethod.BZip2.equals((Object)this.compressionMethod)) {
                return new BZip2CompressorOutputStream(destinationStream);
            }
            throw new OsmosisRuntimeException("Compression method " + this.compressionMethod + " is not recognized.");
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to instantiate a " + this.compressionMethod + " compression stream.", (Throwable)e);
        }
    }

    public InputStream createCompressionInputStream(InputStream sourceStream) {
        try {
            if (CompressionMethod.None.equals((Object)this.compressionMethod)) {
                return sourceStream;
            }
            if (CompressionMethod.GZip.equals((Object)this.compressionMethod)) {
                return new GZIPInputStream(sourceStream);
            }
            if (CompressionMethod.BZip2.equals((Object)this.compressionMethod)) {
                return new BZip2CompressorInputStream(sourceStream);
            }
            throw new OsmosisRuntimeException("Compression method " + this.compressionMethod + " is not recognized.");
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to instantiate a " + this.compressionMethod + " compression stream.", (Throwable)e);
        }
    }
}

