/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.xml.common.XmlTimestampFormat;

public class ElementWriter {
    private static final int INDENT_SPACES_PER_LEVEL = 2;
    private static final Map<Character, String> XML_ENCODING = new HashMap<Character, String>();
    private Writer myWriter;
    private final String myElementName;
    private final int myIndentLevel;
    private final TimestampFormat myTimestampFormat;
    private String myLineSeparator;

    protected ElementWriter(String anElementName, int anIndentionLevel) {
        this.myElementName = anElementName;
        this.myIndentLevel = anIndentionLevel;
        this.myTimestampFormat = new XmlTimestampFormat();
        this.myLineSeparator = System.getProperty("line.separator");
    }

    public void setWriter(Writer aWriter) {
        if (aWriter == null) {
            throw new IllegalArgumentException("null writer given");
        }
        this.myWriter = aWriter;
    }

    private void writeIndent() throws IOException {
        int indentSpaceCount = this.myIndentLevel * 2;
        for (int i = 0; i < indentSpaceCount; ++i) {
            this.myWriter.append(' ');
        }
    }

    private String escapeData(String data) {
        StringBuilder buffer = null;
        for (int i = 0; i < data.length(); ++i) {
            char currentChar = data.charAt(i);
            String replacement = XML_ENCODING.get(Character.valueOf(currentChar));
            if (replacement != null) {
                if (buffer == null) {
                    buffer = new StringBuilder(data.substring(0, i));
                }
                buffer.append(replacement);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(currentChar);
        }
        if (buffer == null) {
            return data;
        }
        return buffer.toString();
    }

    protected TimestampFormat getTimestampFormat() {
        return this.myTimestampFormat;
    }

    protected void beginOpenElement() {
        try {
            this.writeIndent();
            this.myWriter.append('<');
            this.myWriter.append(this.myElementName);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", (Throwable)e);
        }
    }

    protected void endOpenElement(boolean closeElement) {
        try {
            if (closeElement) {
                this.myWriter.append('/');
            }
            this.myWriter.append('>');
            this.myWriter.append(this.myLineSeparator);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", (Throwable)e);
        }
    }

    protected void addAttribute(String name, String value) {
        try {
            this.myWriter.append(' ');
            this.myWriter.append(name);
            this.myWriter.append("=\"");
            this.myWriter.append(this.escapeData(value));
            this.myWriter.append('\"');
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", (Throwable)e);
        }
    }

    protected void closeElement() {
        try {
            this.writeIndent();
            this.myWriter.append("</");
            this.myWriter.append(this.myElementName);
            this.myWriter.append('>');
            this.myWriter.append(this.myLineSeparator);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", (Throwable)e);
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            if (i == 9 || i == 10 || i == 13) continue;
            XML_ENCODING.put(Character.valueOf((char)i), "");
        }
        XML_ENCODING.put(Character.valueOf('\u007f'), "");
        XML_ENCODING.put(Character.valueOf('<'), "&lt;");
        XML_ENCODING.put(Character.valueOf('>'), "&gt;");
        XML_ENCODING.put(Character.valueOf('\"'), "&quot;");
        XML_ENCODING.put(Character.valueOf('\''), "&apos;");
        XML_ENCODING.put(Character.valueOf('&'), "&amp;");
        XML_ENCODING.put(Character.valueOf('\n'), "&#xA;");
        XML_ENCODING.put(Character.valueOf('\r'), "&#xD;");
        XML_ENCODING.put(Character.valueOf('\t'), "&#x9;");
    }
}

