/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.SourceElementProcessor;
import org.xml.sax.Attributes;

public class BoundsElementProcessor
extends SourceElementProcessor {
    private Bound bound;
    private String defaultOrigin;

    public BoundsElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing, String defaultOrigin) {
        super(parentProcessor, sink, enableDateParsing);
        this.defaultOrigin = defaultOrigin;
    }

    @Override
    public void begin(Attributes attributes) {
        double bottom = this.getRequiredDoubleValue(attributes, "minlat");
        double left = this.getRequiredDoubleValue(attributes, "minlon");
        double top = this.getRequiredDoubleValue(attributes, "maxlat");
        double right = this.getRequiredDoubleValue(attributes, "maxlon");
        String origin = attributes.getValue("origin");
        if (origin == null) {
            origin = this.defaultOrigin;
        }
        this.bound = new Bound(right, left, top, bottom, origin);
    }

    private double getRequiredDoubleValue(Attributes attributes, String attributeName) {
        String valueString = attributes.getValue(attributeName);
        if (valueString == null) {
            throw new OsmosisRuntimeException(String.format("Required attribute %s of the bounds element is missing", attributeName));
        }
        try {
            return Double.parseDouble(valueString);
        }
        catch (NumberFormatException e) {
            throw new OsmosisRuntimeException(String.format("Cannot parse the %s attribute of the bounds element", attributeName), (Throwable)e);
        }
    }

    @Override
    public void end() {
        this.getSink().process((EntityContainer)new BoundContainer(this.bound));
        this.bound = null;
    }
}

