/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.Calendar;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.domain.common.UnparsedTimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.XmlTimestampFormat;
import org.openstreetmap.osmosis.xml.v0_6.impl.MemberTypeParser;

public class FastXmlParser {
    private static final String ELEMENT_NAME_BOUND = "bound";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NODE_REFERENCE = "nd";
    private static final String ELEMENT_NAME_MEMBER = "member";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_GENERATOR = "generator";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER_ID = "uid";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_LATITUDE = "lat";
    private static final String ATTRIBUTE_NAME_LONGITUDE = "lon";
    private static final String ATTRIBUTE_NAME_KEY = "k";
    private static final String ATTRIBUTE_NAME_VALUE = "v";
    private static final String ATTRIBUTE_NAME_REF = "ref";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_ROLE = "role";
    private static final String ATTRIBUTE_NAME_BOX = "box";
    private static final String ATTRIBUTE_NAME_ORIGIN = "origin";
    private static final Logger LOG = Logger.getLogger(FastXmlParser.class.getName());
    private static final Object ELEMENT_NAME_BOUNDS = "bounds";
    private final XMLStreamReader reader;
    private final Sink sink;
    private final boolean enableDateParsing;
    private final MemberTypeParser memberTypeParser;
    private TimestampFormat timestampFormat;
    private TimestampContainer dummyTimestampContainer;

    public FastXmlParser(Sink sink, XMLStreamReader reader, boolean enableDateParsing) {
        this.sink = sink;
        this.enableDateParsing = enableDateParsing;
        this.reader = reader;
        if (enableDateParsing) {
            this.timestampFormat = new XmlTimestampFormat();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            this.dummyTimestampContainer = new SimpleTimestampContainer(calendar.getTime());
        }
        this.memberTypeParser = new MemberTypeParser();
    }

    private TimestampContainer parseTimestamp(String data) {
        if (this.enableDateParsing) {
            return new UnparsedTimestampContainer(this.timestampFormat, data);
        }
        return this.dummyTimestampContainer;
    }

    private void readUnknownElement() throws XMLStreamException {
        int level = 0;
        do {
            if (this.reader.getEventType() == 1) {
                ++level;
            } else if (this.reader.getEventType() == 2) {
                --level;
            }
            this.reader.nextTag();
        } while (level > 0);
    }

    private OsmUser readUser() {
        String rawUserId = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_USER_ID);
        String rawUserName = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_USER);
        if (rawUserId != null) {
            int userId = Integer.parseInt(rawUserId);
            String userName = rawUserName == null ? "" : rawUserName;
            return new OsmUser(userId, userName);
        }
        return OsmUser.NONE;
    }

    private long readChangesetId() {
        String changesetIdAttribute = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_CHANGESET_ID);
        if (changesetIdAttribute != null) {
            return Long.parseLong(changesetIdAttribute);
        }
        return 0L;
    }

    private Bound readBound() throws Exception {
        Double right;
        Double top;
        Double left;
        Double bottom;
        String boxString = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_BOX);
        if (boxString == null) {
            throw new OsmosisRuntimeException("Missing required box attribute of bound element");
        }
        String[] boundStrings = boxString.split(",");
        if (boundStrings.length != 4) {
            throw new OsmosisRuntimeException("Badly formed box attribute of bound element");
        }
        try {
            bottom = Double.parseDouble(boundStrings[0]);
            left = Double.parseDouble(boundStrings[1]);
            top = Double.parseDouble(boundStrings[2]);
            right = Double.parseDouble(boundStrings[3]);
        }
        catch (NumberFormatException e) {
            throw new OsmosisRuntimeException("Can't parse box attribute of bound element", (Throwable)e);
        }
        String origin = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ORIGIN);
        if (origin == null || origin.equals("")) {
            throw new OsmosisRuntimeException("Origin attribute of bound element is empty or missing.");
        }
        Bound bound = new Bound(right.doubleValue(), left.doubleValue(), top.doubleValue(), bottom.doubleValue(), origin);
        this.reader.nextTag();
        this.reader.nextTag();
        return bound;
    }

    private Bound readBounds(String defaultOrigin) throws Exception {
        double bottom = this.getRequiredDoubleValue("minlat");
        double left = this.getRequiredDoubleValue("minlon");
        double top = this.getRequiredDoubleValue("maxlat");
        double right = this.getRequiredDoubleValue("maxlon");
        String origin = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ORIGIN);
        if (origin == null) {
            origin = defaultOrigin;
        }
        this.reader.nextTag();
        this.reader.nextTag();
        return new Bound(right, left, top, bottom, origin);
    }

    private double getRequiredDoubleValue(String attributeName) {
        String valueString = this.reader.getAttributeValue(null, attributeName);
        if (valueString == null) {
            throw new OsmosisRuntimeException(String.format("Required attribute %s of the bounds element is missing", attributeName));
        }
        try {
            return Double.parseDouble(valueString);
        }
        catch (NumberFormatException e) {
            throw new OsmosisRuntimeException(String.format("Cannot parse the %s attribute of the bounds element", attributeName), (Throwable)e);
        }
    }

    private Tag readTag() throws Exception {
        Tag tag = new Tag(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_KEY), this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VALUE));
        this.reader.nextTag();
        this.reader.nextTag();
        return tag;
    }

    private Node readNode() throws Exception {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        int version = Integer.parseInt(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION));
        TimestampContainer timestamp = this.parseTimestamp(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP));
        long changesetId = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_CHANGESET_ID));
        OsmUser user = this.readUser();
        changesetId = this.readChangesetId();
        double latitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LATITUDE));
        double longitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LONGITUDE));
        Node node = new Node(new CommonEntityData(id, version, timestamp, user, changesetId), latitude, longitude);
        this.reader.nextTag();
        while (this.reader.getEventType() == 1) {
            if (this.reader.getLocalName().equals(ELEMENT_NAME_TAG)) {
                node.getTags().add(this.readTag());
                continue;
            }
            this.readUnknownElement();
        }
        this.reader.nextTag();
        return node;
    }

    private WayNode readWayNode() throws Exception {
        WayNode node = new WayNode(Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF)));
        this.reader.nextTag();
        this.reader.nextTag();
        return node;
    }

    private Way readWay() throws Exception {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        int version = Integer.parseInt(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION));
        TimestampContainer timestamp = this.parseTimestamp(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP));
        OsmUser user = this.readUser();
        long changesetId = this.readChangesetId();
        Way way = new Way(new CommonEntityData(id, version, timestamp, user, changesetId));
        this.reader.nextTag();
        while (this.reader.getEventType() == 1) {
            if (this.reader.getLocalName().equals(ELEMENT_NAME_TAG)) {
                way.getTags().add(this.readTag());
                continue;
            }
            if (this.reader.getLocalName().equals(ELEMENT_NAME_NODE_REFERENCE)) {
                way.getWayNodes().add(this.readWayNode());
                continue;
            }
            this.readUnknownElement();
        }
        this.reader.nextTag();
        return way;
    }

    private RelationMember readRelationMember() throws Exception {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF));
        EntityType type = this.memberTypeParser.parse(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TYPE));
        String role = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ROLE);
        RelationMember relationMember = new RelationMember(id, type, role);
        this.reader.nextTag();
        this.reader.nextTag();
        return relationMember;
    }

    private Relation readRelation() throws Exception {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        int version = Integer.parseInt(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION));
        TimestampContainer timestamp = this.parseTimestamp(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP));
        OsmUser user = this.readUser();
        long changesetId = this.readChangesetId();
        Relation relation = new Relation(new CommonEntityData(id, version, timestamp, user, changesetId));
        this.reader.nextTag();
        while (this.reader.getEventType() == 1) {
            if (this.reader.getLocalName().equals(ELEMENT_NAME_TAG)) {
                relation.getTags().add(this.readTag());
                continue;
            }
            if (this.reader.getLocalName().equals(ELEMENT_NAME_MEMBER)) {
                relation.getMembers().add(this.readRelationMember());
                continue;
            }
            this.readUnknownElement();
        }
        this.reader.nextTag();
        return relation;
    }

    public void readOsm() {
        block10: {
            try {
                String generator = null;
                if (this.reader.nextTag() == 1 && this.reader.getLocalName().equals("osm")) {
                    String fileVersion = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION);
                    if (!"0.6".equals(fileVersion)) {
                        LOG.warning("Expected version 0.6 but received " + fileVersion + ".");
                    }
                    generator = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_GENERATOR);
                    this.reader.nextTag();
                    if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(ELEMENT_NAME_BOUND)) {
                        LOG.fine("Legacy <bound> element encountered.");
                        this.sink.process((EntityContainer)new BoundContainer(this.readBound()));
                    }
                    if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(ELEMENT_NAME_BOUNDS)) {
                        this.sink.process((EntityContainer)new BoundContainer(this.readBounds(generator)));
                    }
                    while (this.reader.getEventType() == 1) {
                        if (this.reader.getLocalName().equals(ELEMENT_NAME_NODE)) {
                            this.sink.process((EntityContainer)new NodeContainer(this.readNode()));
                            continue;
                        }
                        if (this.reader.getLocalName().equals(ELEMENT_NAME_WAY)) {
                            this.sink.process((EntityContainer)new WayContainer(this.readWay()));
                            continue;
                        }
                        if (this.reader.getLocalName().equals(ELEMENT_NAME_RELATION)) {
                            this.sink.process((EntityContainer)new RelationContainer(this.readRelation()));
                            continue;
                        }
                        this.readUnknownElement();
                    }
                    break block10;
                }
                throw new XMLStreamException();
            }
            catch (Exception e) {
                throw new OsmosisRuntimeException((Throwable)e);
            }
        }
    }
}

