/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import java.util.Set;
import java.util.function.Predicate;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.AbstractRemoteServiceProxy;
import org.opentcs.access.rmi.services.RemoteTCSObjectService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;

abstract class RemoteTCSObjectServiceProxy<R extends RemoteTCSObjectService>
extends AbstractRemoteServiceProxy<R>
implements TCSObjectService {
    RemoteTCSObjectServiceProxy() {
    }

    @Override
    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, TCSObjectReference<T> ref) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTCSObjectService)this.getRemoteService()).fetchObject(this.getClientId(), clazz, ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, String name) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTCSObjectService)this.getRemoteService()).fetchObject(this.getClientId(), clazz, name);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public <T extends TCSObject<T>> Set<T> fetchObjects(Class<T> clazz) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTCSObjectService)this.getRemoteService()).fetchObjects(this.getClientId(), clazz);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public <T extends TCSObject<T>> Set<T> fetchObjects(Class<T> clazz, Predicate<? super T> predicate) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTCSObjectService)this.getRemoteService()).fetchObjects(this.getClientId(), clazz, predicate);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateObjectProperty(TCSObjectReference<?> ref, String key, String value) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteTCSObjectService)this.getRemoteService()).updateObjectProperty(this.getClientId(), ref, key, value);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void appendObjectHistoryEntry(TCSObjectReference<?> ref, ObjectHistory.Entry entry) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteTCSObjectService)this.getRemoteService()).appendObjectHistoryEntry(this.getClientId(), ref, entry);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

