/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.RemoteTCSObjectServiceProxy;
import org.opentcs.access.rmi.services.RemoteTransportOrderService;
import org.opentcs.access.to.order.OrderSequenceCreationTO;
import org.opentcs.access.to.order.TransportOrderCreationTO;
import org.opentcs.components.kernel.services.TransportOrderService;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;

class RemoteTransportOrderServiceProxy
extends RemoteTCSObjectServiceProxy<RemoteTransportOrderService>
implements TransportOrderService {
    RemoteTransportOrderServiceProxy() {
    }

    @Override
    public OrderSequence createOrderSequence(OrderSequenceCreationTO to) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTransportOrderService)this.getRemoteService()).createOrderSequence(this.getClientId(), to);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public TransportOrder createTransportOrder(TransportOrderCreationTO to) throws ObjectUnknownException, ObjectExistsException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteTransportOrderService)this.getRemoteService()).createTransportOrder(this.getClientId(), to);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void markOrderSequenceComplete(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteTransportOrderService)this.getRemoteService()).markOrderSequenceComplete(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateTransportOrderIntendedVehicle(TCSObjectReference<TransportOrder> orderRef, TCSObjectReference<Vehicle> vehicleRef) throws ObjectUnknownException, IllegalArgumentException {
        this.checkServiceAvailability();
        try {
            ((RemoteTransportOrderService)this.getRemoteService()).updateTransportOrderIntendedVehicle(this.getClientId(), orderRef, vehicleRef);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

