/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CreationTO
implements Serializable {
    @Nonnull
    private final String name;
    @Nonnull
    private final Map<String, String> properties;

    public CreationTO(@Nonnull String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.properties = Map.of();
    }

    protected CreationTO(@Nonnull String name, @Nonnull Map<String, String> properties) {
        this.name = Objects.requireNonNull(name, "name");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public CreationTO withName(@Nonnull String name) {
        return new CreationTO(name, this.properties);
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected Map<String, String> getModifiableProperties() {
        return this.properties;
    }

    public CreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new CreationTO(this.name, properties);
    }

    public CreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new CreationTO(this.name, this.propertiesWith(key, value));
    }

    protected final Map<String, String> propertiesWith(String key, String value) {
        return CreationTO.mapWithMapping(this.properties, key, value);
    }

    protected static final <K, V> Map<K, V> mapWithMapping(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(map, "map");
        Objects.requireNonNull(key, "key");
        HashMap<K, V> result = new HashMap<K, V>(map);
        if (value == null) {
            result.remove(key);
        } else {
            result.put(key, value);
        }
        return result;
    }

    protected static final <T> List<T> listWithAppendix(List<T> list, T newElement) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.addAll(list);
        result.add(newElement);
        return result;
    }
}

