/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.GroupCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;

public class PlantModelCreationTO
extends CreationTO
implements Serializable {
    private final List<PointCreationTO> points;
    private final List<PathCreationTO> paths;
    private final List<LocationTypeCreationTO> locationTypes;
    private final List<LocationCreationTO> locations;
    private final List<BlockCreationTO> blocks;
    @Deprecated
    private final List<GroupCreationTO> groups;
    private final List<VehicleCreationTO> vehicles;
    private final List<VisualLayoutCreationTO> visualLayouts;

    public PlantModelCreationTO(String name) {
        super(name);
        this.points = List.of();
        this.paths = List.of();
        this.locationTypes = List.of();
        this.locations = List.of();
        this.blocks = List.of();
        this.groups = List.of();
        this.vehicles = List.of();
        this.visualLayouts = List.of(this.defaultVisualLayout());
    }

    private PlantModelCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull List<PointCreationTO> points, @Nonnull List<PathCreationTO> paths, @Nonnull List<LocationTypeCreationTO> locationTypes, @Nonnull List<LocationCreationTO> locations, @Nonnull List<BlockCreationTO> blocks, @Nonnull List<GroupCreationTO> groups, @Nonnull List<VehicleCreationTO> vehicles, @Nonnull List<VisualLayoutCreationTO> visualLayouts) {
        super(name, properties);
        this.points = Objects.requireNonNull(points, "points");
        this.paths = Objects.requireNonNull(paths, "paths");
        this.locationTypes = Objects.requireNonNull(locationTypes, "locationTypes");
        this.locations = Objects.requireNonNull(locations, "locations");
        this.blocks = Objects.requireNonNull(blocks, "blocks");
        this.groups = Objects.requireNonNull(groups, "groups");
        this.vehicles = Objects.requireNonNull(vehicles, "vehicles");
        this.visualLayouts = Objects.requireNonNull(visualLayouts, "visualLayouts");
    }

    public List<PointCreationTO> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public PlantModelCreationTO withPoints(@Nonnull List<PointCreationTO> points) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withPoint(@Nonnull PointCreationTO point) {
        Objects.requireNonNull(point, "point");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), PlantModelCreationTO.listWithAppendix(this.points, point), this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public List<PathCreationTO> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public PlantModelCreationTO withPaths(@Nonnull List<PathCreationTO> paths) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withPath(@Nonnull PathCreationTO path) {
        Objects.requireNonNull(path, "path");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, PlantModelCreationTO.listWithAppendix(this.paths, path), this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public List<LocationTypeCreationTO> getLocationTypes() {
        return Collections.unmodifiableList(this.locationTypes);
    }

    public PlantModelCreationTO withLocationTypes(@Nonnull List<LocationTypeCreationTO> locationTypes) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withLocationType(@Nonnull LocationTypeCreationTO locationType) {
        Objects.requireNonNull(locationType, "locationType");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, PlantModelCreationTO.listWithAppendix(this.locationTypes, locationType), this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public List<LocationCreationTO> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public PlantModelCreationTO withLocations(@Nonnull List<LocationCreationTO> locations) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withLocation(@Nonnull LocationCreationTO location) {
        Objects.requireNonNull(location, "location");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, PlantModelCreationTO.listWithAppendix(this.locations, location), this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public List<BlockCreationTO> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public PlantModelCreationTO withBlocks(@Nonnull List<BlockCreationTO> blocks) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withBlock(@Nonnull BlockCreationTO block) {
        Objects.requireNonNull(block, "block");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, CreationTO.listWithAppendix(this.blocks, block), this.groups, this.vehicles, this.visualLayouts);
    }

    @Deprecated
    public List<GroupCreationTO> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Deprecated
    public PlantModelCreationTO withGroups(@Nonnull List<GroupCreationTO> groups) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, groups, this.vehicles, this.visualLayouts);
    }

    @Deprecated
    public PlantModelCreationTO withGroup(@Nonnull GroupCreationTO group) {
        Objects.requireNonNull(group, "group");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, PlantModelCreationTO.listWithAppendix(this.groups, group), this.vehicles, this.visualLayouts);
    }

    public List<VehicleCreationTO> getVehicles() {
        return Collections.unmodifiableList(this.vehicles);
    }

    public PlantModelCreationTO withVehicles(@Nonnull List<VehicleCreationTO> vehicles) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, vehicles, this.visualLayouts);
    }

    public PlantModelCreationTO withVehicle(@Nonnull VehicleCreationTO vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, PlantModelCreationTO.listWithAppendix(this.vehicles, vehicle), this.visualLayouts);
    }

    public VisualLayoutCreationTO getVisualLayout() {
        return this.visualLayouts.get(this.visualLayouts.size() - 1);
    }

    @Deprecated
    public List<VisualLayoutCreationTO> getVisualLayouts() {
        return Collections.unmodifiableList(this.visualLayouts);
    }

    @Deprecated
    public PlantModelCreationTO withVisualLayouts(@Nonnull List<VisualLayoutCreationTO> visualLayouts) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, visualLayouts);
    }

    public PlantModelCreationTO withVisualLayout(@Nonnull VisualLayoutCreationTO visualLayout) {
        Objects.requireNonNull(visualLayout, "visualLayout");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, PlantModelCreationTO.listWithAppendix(this.visualLayouts, visualLayout));
    }

    @Override
    public PlantModelCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PlantModelCreationTO(this.getName(), properties, this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    @Override
    public PlantModelCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PlantModelCreationTO(this.getName(), this.propertiesWith(key, value), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.groups, this.vehicles, this.visualLayouts);
    }

    public String toString() {
        return "PlantModelCreationTO{name=" + this.getName() + ", points=" + this.points + ", paths=" + this.paths + ", locationTypes=" + this.locationTypes + ", locations=" + this.locations + ", blocks=" + this.blocks + ", groups=" + this.groups + ", vehicles=" + this.vehicles + ", visualLayouts=" + this.visualLayouts + ", properties=" + this.getProperties() + "}";
    }

    private VisualLayoutCreationTO defaultVisualLayout() {
        return new VisualLayoutCreationTO("VLayout").withLayer(new Layer(0, 0, true, "Default layer", 0)).withLayerGroup(new LayerGroup(0, "Default layer group", true));
    }
}

