/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Envelope;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Pose;
import org.opentcs.data.model.Triple;

public class PointCreationTO
extends CreationTO
implements Serializable {
    private final Pose pose;
    @Nonnull
    private final Point.Type type;
    private final Map<String, Envelope> vehicleEnvelopes;
    private final Layout layout;

    public PointCreationTO(@Nonnull String name) {
        super(name);
        this.pose = new Pose(new Triple(0L, 0L, 0L), Double.NaN);
        this.type = Point.Type.HALT_POSITION;
        this.vehicleEnvelopes = Map.of();
        this.layout = new Layout();
    }

    private PointCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull Pose pose, @Nonnull Point.Type type, @Nonnull Map<String, Envelope> vehicleEnvelopes, @Nonnull Layout layout) {
        super(name, properties);
        this.pose = Objects.requireNonNull(pose, "pose");
        this.type = Objects.requireNonNull(type, "type");
        this.vehicleEnvelopes = Objects.requireNonNull(vehicleEnvelopes, "vehicleEnvelopes");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public PointCreationTO withName(@Nonnull String name) {
        return new PointCreationTO(name, this.getModifiableProperties(), this.pose, this.type, this.vehicleEnvelopes, this.layout);
    }

    @Nonnull
    public Pose getPose() {
        return this.pose;
    }

    public PointCreationTO withPose(@Nonnull Pose pose) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), pose, this.type, this.vehicleEnvelopes, this.layout);
    }

    @Deprecated
    @Nonnull
    public Triple getPosition() {
        return this.pose.getPosition();
    }

    @Deprecated
    public PointCreationTO withPosition(@Nonnull Triple position) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.pose.withPosition(position), this.type, this.vehicleEnvelopes, this.layout);
    }

    @Deprecated
    public double getVehicleOrientationAngle() {
        return this.pose.getOrientationAngle();
    }

    @Deprecated
    public PointCreationTO withVehicleOrientationAngle(double vehicleOrientationAngle) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.pose.withOrientationAngle(vehicleOrientationAngle), this.type, this.vehicleEnvelopes, this.layout);
    }

    @Nonnull
    public Point.Type getType() {
        return this.type;
    }

    public PointCreationTO withType(@Nonnull Point.Type type) {
        return new PointCreationTO(this.getName(), this.getProperties(), this.pose, type, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public PointCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PointCreationTO(this.getName(), properties, this.pose, this.type, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public PointCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PointCreationTO(this.getName(), this.propertiesWith(key, value), this.pose, this.type, this.vehicleEnvelopes, this.layout);
    }

    public Map<String, Envelope> getVehicleEnvelopes() {
        return this.vehicleEnvelopes;
    }

    public PointCreationTO withVehicleEnvelopes(@Nonnull Map<String, Envelope> vehicleEnvelopes) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.pose, this.type, vehicleEnvelopes, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public PointCreationTO withLayout(Layout layout) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.pose, this.type, this.vehicleEnvelopes, layout);
    }

    public String toString() {
        return "PointCreationTO{name=" + this.getName() + ", pose=" + this.pose + ", type=" + this.type + ", vehicleEnvelopes=" + this.vehicleEnvelopes + ", layout=" + this.layout + ", properties=" + this.getProperties() + "}";
    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), 0);
        }

        public Layout(Couple position, Couple labelOffset, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, layerId);
        }

        public String toString() {
            return "Layout{position=" + this.position + ", labelOffset=" + this.labelOffset + ", layerId=" + this.layerId + "}";
        }
    }
}

