/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.order;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.access.to.CreationTO;

public class OrderSequenceCreationTO
extends CreationTO
implements Serializable {
    private final boolean incompleteName;
    private final String type;
    @Nullable
    private final String intendedVehicleName;
    private final boolean failureFatal;

    public OrderSequenceCreationTO(@Nonnull String name) {
        super(name);
        this.incompleteName = false;
        this.type = "-";
        this.intendedVehicleName = null;
        this.failureFatal = false;
    }

    private OrderSequenceCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, boolean incompleteName, @Nonnull String type, @Nullable String intendedVehicleName, boolean failureFatal) {
        super(name, properties);
        this.incompleteName = incompleteName;
        this.type = Objects.requireNonNull(type, "type");
        this.intendedVehicleName = intendedVehicleName;
        this.failureFatal = failureFatal;
    }

    @Override
    public OrderSequenceCreationTO withName(@Nonnull String name) {
        return new OrderSequenceCreationTO(name, this.getModifiableProperties(), this.incompleteName, this.type, this.intendedVehicleName, this.failureFatal);
    }

    @Override
    public OrderSequenceCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new OrderSequenceCreationTO(this.getName(), properties, this.incompleteName, this.type, this.intendedVehicleName, this.failureFatal);
    }

    @Override
    public OrderSequenceCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new OrderSequenceCreationTO(this.getName(), this.propertiesWith(key, value), this.incompleteName, this.type, this.intendedVehicleName, this.failureFatal);
    }

    public boolean hasIncompleteName() {
        return this.incompleteName;
    }

    public OrderSequenceCreationTO withIncompleteName(boolean incompleteName) {
        return new OrderSequenceCreationTO(this.getName(), this.getModifiableProperties(), incompleteName, this.type, this.intendedVehicleName, this.failureFatal);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public OrderSequenceCreationTO withType(@Nonnull String type) {
        return new OrderSequenceCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, type, this.intendedVehicleName, this.failureFatal);
    }

    @Nullable
    public String getIntendedVehicleName() {
        return this.intendedVehicleName;
    }

    public OrderSequenceCreationTO withIntendedVehicleName(@Nullable String intendedVehicleName) {
        return new OrderSequenceCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.type, intendedVehicleName, this.failureFatal);
    }

    public boolean isFailureFatal() {
        return this.failureFatal;
    }

    public OrderSequenceCreationTO withFailureFatal(boolean failureFatal) {
        return new OrderSequenceCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.type, this.intendedVehicleName, failureFatal);
    }
}

