/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.order;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.order.DestinationCreationTO;

public class TransportOrderCreationTO
extends CreationTO
implements Serializable {
    private final boolean incompleteName;
    @Nonnull
    private final List<DestinationCreationTO> destinations;
    @Nullable
    private final String peripheralReservationToken;
    @Nullable
    private final String wrappingSequence;
    @Nonnull
    private final Set<String> dependencyNames;
    @Nullable
    private final String intendedVehicleName;
    @Nonnull
    private final String type;
    @Nonnull
    private final Instant deadline;
    private final boolean dispensable;

    public TransportOrderCreationTO(@Nonnull String name, @Nonnull List<DestinationCreationTO> destinations) {
        super(name);
        this.incompleteName = false;
        this.destinations = Objects.requireNonNull(destinations, "destinations");
        this.peripheralReservationToken = null;
        this.wrappingSequence = null;
        this.dependencyNames = Set.of();
        this.intendedVehicleName = null;
        this.type = "-";
        this.deadline = Instant.MAX;
        this.dispensable = false;
    }

    private TransportOrderCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, boolean incompleteName, @Nonnull List<DestinationCreationTO> destinations, @Nullable String peripheralReservationToken, @Nullable String wrappingSequence, @Nonnull Set<String> dependencyNames, @Nullable String intendedVehicleName, @Nonnull String type, @Nonnull Instant deadline, boolean dispensable) {
        super(name, properties);
        this.incompleteName = incompleteName;
        this.destinations = Objects.requireNonNull(destinations, "destinations");
        this.peripheralReservationToken = peripheralReservationToken;
        this.wrappingSequence = wrappingSequence;
        this.dependencyNames = Objects.requireNonNull(dependencyNames, "dependencyNames");
        this.intendedVehicleName = intendedVehicleName;
        this.type = Objects.requireNonNull(type, "type");
        this.deadline = Objects.requireNonNull(deadline, "deadline");
        this.dispensable = dispensable;
    }

    @Override
    public TransportOrderCreationTO withName(@Nonnull String name) {
        return new TransportOrderCreationTO(name, this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Override
    public TransportOrderCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new TransportOrderCreationTO(this.getName(), properties, this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Override
    public TransportOrderCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new TransportOrderCreationTO(this.getName(), this.propertiesWith(key, value), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    public boolean hasIncompleteName() {
        return this.incompleteName;
    }

    public TransportOrderCreationTO withIncompleteName(boolean incompleteName) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nonnull
    public List<DestinationCreationTO> getDestinations() {
        return Collections.unmodifiableList(this.destinations);
    }

    public TransportOrderCreationTO withDestinations(@Nonnull List<DestinationCreationTO> destinations) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nullable
    public String getPeripheralReservationToken() {
        return this.peripheralReservationToken;
    }

    public TransportOrderCreationTO withPeripheralReservationToken(@Nullable String peripheralReservationToken) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nullable
    public String getWrappingSequence() {
        return this.wrappingSequence;
    }

    public TransportOrderCreationTO withWrappingSequence(@Nullable String wrappingSequence) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nonnull
    public Set<String> getDependencyNames() {
        return Collections.unmodifiableSet(this.dependencyNames);
    }

    public TransportOrderCreationTO withDependencyNames(@Nonnull Set<String> dependencyNames) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, dependencyNames, this.intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nullable
    public String getIntendedVehicleName() {
        return this.intendedVehicleName;
    }

    public TransportOrderCreationTO withIntendedVehicleName(@Nullable String intendedVehicleName) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, intendedVehicleName, this.type, this.deadline, this.dispensable);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public TransportOrderCreationTO withType(@Nonnull String type) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, type, this.deadline, this.dispensable);
    }

    @Nonnull
    public Instant getDeadline() {
        return this.deadline;
    }

    public TransportOrderCreationTO withDeadline(@Nonnull Instant deadline) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, deadline, this.dispensable);
    }

    public boolean isDispensable() {
        return this.dispensable;
    }

    public TransportOrderCreationTO withDispensable(boolean dispensable) {
        return new TransportOrderCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.destinations, this.peripheralReservationToken, this.wrappingSequence, this.dependencyNames, this.intendedVehicleName, this.type, this.deadline, dispensable);
    }
}

