/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.components.kernel;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.ResourceAllocationException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.Vehicle;

public interface Scheduler
extends Lifecycle {
    public static final String PROPKEY_BLOCK_ENTRY_DIRECTION = "tcs:blockEntryDirection";

    public void claim(@Nonnull Client var1, @Nonnull List<Set<TCSResource<?>>> var2);

    @Deprecated
    default public void updateProgressIndex(@Nonnull Client client, int index) throws IllegalArgumentException {
    }

    @Deprecated
    default public void unclaim(@Nonnull Client client) throws IllegalArgumentException {
        this.claim(client, List.of());
    }

    public void allocate(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2) throws IllegalArgumentException;

    default public boolean mayAllocateNow(@Nonnull Client client, @Nonnull Set<TCSResource<?>> resources) {
        return false;
    }

    public void allocateNow(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2) throws ResourceAllocationException;

    public void free(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2);

    public void freeAll(@Nonnull Client var1);

    default public void clearPendingAllocations(@Nonnull Client client) {
    }

    default public void reschedule() {
    }

    @Nonnull
    public Map<String, Set<TCSResource<?>>> getAllocations();

    public void preparationSuccessful(@Nonnull Module var1, @Nonnull Client var2, @Nonnull Set<TCSResource<?>> var3);

    public static interface Client {
        @Nonnull
        public String getId();

        @Nullable
        default public TCSObjectReference<Vehicle> getRelatedVehicle() {
            return null;
        }

        public boolean allocationSuccessful(@Nonnull Set<TCSResource<?>> var1);

        public void allocationFailed(@Nonnull Set<TCSResource<?>> var1);
    }

    public static interface Module
    extends Lifecycle {
        @Deprecated
        default public void claim(@Nonnull Client client, @Nonnull List<Set<TCSResource<?>>> claim) {
        }

        @Deprecated
        default public void unclaim(@Nonnull Client client) {
        }

        public void setAllocationState(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2, @Nonnull List<Set<TCSResource<?>>> var3);

        public boolean mayAllocate(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2);

        public void prepareAllocation(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2);

        public boolean hasPreparedAllocation(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2);

        public void allocationReleased(@Nonnull Client var1, @Nonnull Set<TCSResource<?>> var2);
    }
}

