/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.components.kernel.dipatching;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.components.kernel.dipatching.TransportOrderAssignmentVeto;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.util.Assertions;

public class TransportOrderAssignmentException
extends KernelRuntimeException {
    private final TCSObjectReference<TransportOrder> transportOrder;
    private final TCSObjectReference<Vehicle> vehicle;
    private final TransportOrderAssignmentVeto transportOrderAssignmentVeto;

    public TransportOrderAssignmentException(@Nonnull TCSObjectReference<TransportOrder> transportOrder, @Nullable TCSObjectReference<Vehicle> vehicle, @Nonnull TransportOrderAssignmentVeto transportOrderAssignmentVeto) {
        super("Could not assign transport order '" + transportOrder.getName() + "' to vehicle '" + (vehicle != null ? vehicle.getName() : "null") + "': " + transportOrderAssignmentVeto.name());
        Assertions.checkArgument(transportOrderAssignmentVeto != TransportOrderAssignmentVeto.NO_VETO, "Invalid assignment veto for exception: " + transportOrderAssignmentVeto);
        this.transportOrder = Objects.requireNonNull(transportOrder, "transportOrder");
        this.vehicle = vehicle;
        this.transportOrderAssignmentVeto = Objects.requireNonNull(transportOrderAssignmentVeto, "transportOrderAssignmentVeto");
    }

    @Nonnull
    public TCSObjectReference<TransportOrder> getTransportOrder() {
        return this.transportOrder;
    }

    @Nullable
    public TCSObjectReference<Vehicle> getVehicle() {
        return this.vehicle;
    }

    @Nonnull
    public TransportOrderAssignmentVeto getTransportOrderAssignmentVeto() {
        return this.transportOrderAssignmentVeto;
    }
}

