/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.TCSObject;

public class TCSObjectReference<E extends TCSObject<E>>
implements Serializable {
    private final Class<?> referentClass;
    private final String name;

    protected TCSObjectReference(@Nonnull TCSObject<E> referent) {
        Objects.requireNonNull(referent, "newReferent");
        this.referentClass = referent.getClass();
        this.name = referent.getName();
    }

    public Class<?> getReferentClass() {
        return this.referentClass;
    }

    public final String getName() {
        return this.name;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof TCSObjectReference)) {
            return false;
        }
        TCSObjectReference otherRef = (TCSObjectReference)otherObj;
        return Objects.equals(this.referentClass, otherRef.referentClass) && Objects.equals(this.name, otherRef.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "TCSObjectReference{referentClass=" + this.referentClass + ", name=" + this.name + "}";
    }
}

