/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Couple;
import org.opentcs.util.Assertions;

public class Envelope
implements Serializable {
    private final List<Couple> vertices;

    public Envelope(@Nonnull List<Couple> vertices) {
        this.vertices = Objects.requireNonNull(vertices, "vertices");
        Assertions.checkArgument(!vertices.isEmpty(), "An envelope must contain some vertices.");
        Assertions.checkArgument(Objects.equals(vertices.get(0), vertices.get(vertices.size() - 1)), "An envelope's last vertex must match the first one.");
    }

    public List<Couple> getVertices() {
        return this.vertices;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.vertices);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)obj;
        return Objects.equals(this.vertices, other.vertices);
    }

    public String toString() {
        return "Envelope{vertices=" + this.vertices + "}";
    }
}

