/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.LocationType;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.visualization.LocationRepresentation;

public class Location
extends TCSResource<Location>
implements Serializable {
    private final Triple position;
    private final TCSObjectReference<LocationType> type;
    private final Set<Link> attachedLinks;
    private final boolean locked;
    private final PeripheralInformation peripheralInformation;
    private final Layout layout;

    public Location(String name, TCSObjectReference<LocationType> type) {
        super(name);
        this.type = Objects.requireNonNull(type, "type");
        this.position = new Triple(0L, 0L, 0L);
        this.attachedLinks = new HashSet<Link>();
        this.locked = false;
        this.peripheralInformation = new PeripheralInformation();
        this.layout = new Layout();
    }

    private Location(String name, Map<String, String> properties, ObjectHistory history, TCSObjectReference<LocationType> locationType, Triple position, Set<Link> attachedLinks, boolean locked, PeripheralInformation peripheralInformation, Layout layout) {
        super(name, properties, history);
        this.type = Objects.requireNonNull(locationType, "locationType");
        this.position = Objects.requireNonNull(position, "position");
        this.attachedLinks = new HashSet<Link>((Collection)Objects.requireNonNull(attachedLinks, "attachedLinks"));
        this.locked = locked;
        this.peripheralInformation = Objects.requireNonNull(peripheralInformation, "peripheralInformation");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Location withProperty(String key, String value) {
        return new Location(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.type, this.position, this.attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    public Location withProperties(Map<String, String> properties) {
        return new Location(this.getName(), properties, this.getHistory(), this.type, this.position, this.attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    @Override
    public TCSObject<Location> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Location(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.type, this.position, this.attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    @Override
    public TCSObject<Location> withHistory(ObjectHistory history) {
        return new Location(this.getName(), this.getProperties(), history, this.type, this.position, this.attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    public Triple getPosition() {
        return this.position;
    }

    public Location withPosition(Triple position) {
        return new Location(this.getName(), this.getProperties(), this.getHistory(), this.type, position, this.attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    public TCSObjectReference<LocationType> getType() {
        return this.type;
    }

    public Set<Link> getAttachedLinks() {
        return Collections.unmodifiableSet(this.attachedLinks);
    }

    public Location withAttachedLinks(@Nonnull Set<Link> attachedLinks) {
        return new Location(this.getName(), this.getProperties(), this.getHistory(), this.type, this.position, attachedLinks, this.locked, this.peripheralInformation, this.layout);
    }

    @Nonnull
    public PeripheralInformation getPeripheralInformation() {
        return this.peripheralInformation;
    }

    public Location withPeripheralInformation(@Nonnull PeripheralInformation peripheralInformation) {
        return new Location(this.getName(), this.getProperties(), this.getHistory(), this.type, this.position, this.attachedLinks, this.locked, peripheralInformation, this.layout);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Location withLocked(boolean locked) {
        return new Location(this.getName(), this.getProperties(), this.getHistory(), this.type, this.position, this.attachedLinks, locked, this.peripheralInformation, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Location withLayout(Layout layout) {
        return new Location(this.getName(), this.getProperties(), this.getHistory(), this.type, this.position, this.attachedLinks, this.locked, this.peripheralInformation, layout);
    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final LocationRepresentation locationRepresentation;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), LocationRepresentation.DEFAULT, 0);
        }

        public Layout(Couple position, Couple labelOffset, LocationRepresentation locationRepresentation, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.locationRepresentation = Objects.requireNonNull(locationRepresentation, "locationRepresentation");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.locationRepresentation, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.locationRepresentation, this.layerId);
        }

        public LocationRepresentation getLocationRepresentation() {
            return this.locationRepresentation;
        }

        public Layout withLocationRepresentation(LocationRepresentation locationRepresentation) {
            return new Layout(this.position, this.labelOffset, locationRepresentation, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, this.locationRepresentation, layerId);
        }
    }

    public static class Link
    implements Serializable {
        private final TCSResourceReference<Location> location;
        private final TCSResourceReference<Point> point;
        private final Set<String> allowedOperations;

        public Link(TCSResourceReference<Location> location, TCSResourceReference<Point> point) {
            this.location = Objects.requireNonNull(location, "location");
            this.point = Objects.requireNonNull(point, "point");
            this.allowedOperations = new TreeSet<String>();
        }

        private Link(TCSResourceReference<Location> location, TCSResourceReference<Point> point, Set<String> allowedOperations) {
            this.location = Objects.requireNonNull(location, "location");
            this.point = Objects.requireNonNull(point, "point");
            this.allowedOperations = new TreeSet<String>((Collection)Objects.requireNonNull(allowedOperations, "allowedOperations"));
        }

        public TCSResourceReference<Location> getLocation() {
            return this.location;
        }

        public TCSResourceReference<Point> getPoint() {
            return this.point;
        }

        public Set<String> getAllowedOperations() {
            return Collections.unmodifiableSet(this.allowedOperations);
        }

        public boolean hasAllowedOperation(String operation) {
            Objects.requireNonNull(operation, "operation");
            return this.allowedOperations.contains(operation);
        }

        public Link withAllowedOperations(Set<String> allowedOperations) {
            return new Link(this.location, this.point, allowedOperations);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Link) {
                Link other = (Link)obj;
                return this.point.equals(other.getPoint()) && this.location.equals(other.getLocation());
            }
            return false;
        }

        public int hashCode() {
            return this.location.hashCode() ^ this.point.hashCode();
        }
    }
}

