/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Envelope;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Pose;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;

public class Point
extends TCSResource<Point>
implements Serializable {
    private final Pose pose;
    private final Type type;
    private final Set<TCSObjectReference<Path>> incomingPaths;
    private final Set<TCSObjectReference<Path>> outgoingPaths;
    private final Set<Location.Link> attachedLinks;
    private final TCSObjectReference<Vehicle> occupyingVehicle;
    private final Map<String, Envelope> vehicleEnvelopes;
    private final Layout layout;

    public Point(String name) {
        super(name);
        this.pose = new Pose(new Triple(0L, 0L, 0L), Double.NaN);
        this.type = Type.HALT_POSITION;
        this.incomingPaths = new HashSet<TCSObjectReference<Path>>();
        this.outgoingPaths = new HashSet<TCSObjectReference<Path>>();
        this.attachedLinks = new HashSet<Location.Link>();
        this.occupyingVehicle = null;
        this.vehicleEnvelopes = Map.of();
        this.layout = new Layout();
    }

    private Point(String name, Map<String, String> properties, ObjectHistory history, Pose pose, Type type, Set<TCSObjectReference<Path>> incomingPaths, Set<TCSObjectReference<Path>> outgoingPaths, Set<Location.Link> attachedLinks, TCSObjectReference<Vehicle> occupyingVehicle, Map<String, Envelope> vehicleEnvelopes, Layout layout) {
        super(name, properties, history);
        this.pose = Objects.requireNonNull(pose, "pose");
        this.type = Objects.requireNonNull(type, "type");
        this.incomingPaths = Point.setWithoutNullValues(Objects.requireNonNull(incomingPaths, "incomingPaths"));
        this.outgoingPaths = Point.setWithoutNullValues(Objects.requireNonNull(outgoingPaths, "outgoingPaths"));
        this.attachedLinks = Point.setWithoutNullValues(Objects.requireNonNull(attachedLinks, "attachedLinks"));
        this.occupyingVehicle = occupyingVehicle;
        this.vehicleEnvelopes = Objects.requireNonNull(vehicleEnvelopes, "vehicleEnvelopes");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Point withProperty(String key, String value) {
        return new Point(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Point withProperties(Map<String, String> properties) {
        return new Point(this.getName(), properties, this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public TCSObject<Point> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Point(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public TCSObject<Point> withHistory(ObjectHistory history) {
        return new Point(this.getName(), this.getProperties(), history, this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Pose getPose() {
        return this.pose;
    }

    public Point withPose(Pose pose) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    @Deprecated
    public Triple getPosition() {
        return this.pose.getPosition();
    }

    @Deprecated
    public Point withPosition(Triple position) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose.withPosition(position), this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    @Deprecated
    public double getVehicleOrientationAngle() {
        return this.pose.getOrientationAngle();
    }

    @Deprecated
    public Point withVehicleOrientationAngle(double vehicleOrientationAngle) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose.withOrientationAngle(vehicleOrientationAngle), this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Type getType() {
        return this.type;
    }

    public Point withType(Type type) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public boolean isParkingPosition() {
        return this.type.equals((Object)Type.PARK_POSITION);
    }

    public boolean isHaltingPosition() {
        return this.type.equals((Object)Type.PARK_POSITION) || this.type.equals((Object)Type.HALT_POSITION);
    }

    public TCSObjectReference<Vehicle> getOccupyingVehicle() {
        return this.occupyingVehicle;
    }

    public Point withOccupyingVehicle(TCSObjectReference<Vehicle> occupyingVehicle) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Set<TCSObjectReference<Path>> getIncomingPaths() {
        return Collections.unmodifiableSet(this.incomingPaths);
    }

    public Point withIncomingPaths(Set<TCSObjectReference<Path>> incomingPaths) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Set<TCSObjectReference<Path>> getOutgoingPaths() {
        return Collections.unmodifiableSet(this.outgoingPaths);
    }

    public Point withOutgoingPaths(Set<TCSObjectReference<Path>> outgoingPaths) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, this.incomingPaths, outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Set<Location.Link> getAttachedLinks() {
        return Collections.unmodifiableSet(this.attachedLinks);
    }

    public Point withAttachedLinks(Set<Location.Link> attachedLinks) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, this.layout);
    }

    public Map<String, Envelope> getVehicleEnvelopes() {
        return this.vehicleEnvelopes;
    }

    public Point withVehicleEnvelopes(Map<String, Envelope> vehicleEnvelopes) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, vehicleEnvelopes, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Point withLayout(Layout layout) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.pose, this.type, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.vehicleEnvelopes, layout);
    }

    public static enum Type {
        REPORT_POSITION,
        HALT_POSITION,
        PARK_POSITION;

    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), 0);
        }

        public Layout(Couple position, Couple labelOffset, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, layerId);
        }
    }
}

