/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.order;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.OrderSequence;

public class TransportOrder
extends TCSObject<TransportOrder>
implements Serializable {
    @Nonnull
    private final String type;
    @Nonnull
    private final Set<TCSObjectReference<TransportOrder>> dependencies;
    @Nonnull
    private final List<DriveOrder> driveOrders;
    @Nullable
    private final String peripheralReservationToken;
    private final int currentDriveOrderIndex;
    @Nonnull
    private final State state;
    private final Instant creationTime;
    private final Instant deadline;
    private final Instant finishedTime;
    @Nullable
    private final TCSObjectReference<Vehicle> intendedVehicle;
    @Nullable
    private final TCSObjectReference<Vehicle> processingVehicle;
    @Nullable
    private final TCSObjectReference<OrderSequence> wrappingSequence;
    private final boolean dispensable;

    public TransportOrder(String name, List<DriveOrder> driveOrders) {
        super(name, new HashMap<String, String>(), new ObjectHistory().withEntryAppended(new ObjectHistory.Entry("tcsHistory:orderCreated")));
        this.type = "-";
        this.driveOrders = Objects.requireNonNull(driveOrders, "driveOrders");
        this.peripheralReservationToken = null;
        this.currentDriveOrderIndex = -1;
        this.state = State.RAW;
        this.creationTime = Instant.EPOCH;
        this.intendedVehicle = null;
        this.processingVehicle = null;
        this.deadline = Instant.MAX;
        this.finishedTime = Instant.MAX;
        this.dispensable = false;
        this.wrappingSequence = null;
        this.dependencies = new LinkedHashSet<TCSObjectReference<TransportOrder>>();
    }

    private TransportOrder(String name, Map<String, String> properties, ObjectHistory history, String type, List<DriveOrder> driveOrders, String peripheralReservationToken, int currentDriveOrderIndex, Instant creationTime, TCSObjectReference<Vehicle> intendedVehicle, Instant deadline, boolean dispensable, TCSObjectReference<OrderSequence> wrappingSequence, Set<TCSObjectReference<TransportOrder>> dependencies, TCSObjectReference<Vehicle> processingVehicle, State state, Instant finishedTime) {
        super(name, properties, history);
        this.type = Objects.requireNonNull(type, "type");
        Objects.requireNonNull(driveOrders, "driveOrders");
        this.driveOrders = new ArrayList<DriveOrder>(driveOrders.size());
        for (DriveOrder driveOrder : driveOrders) {
            this.driveOrders.add(driveOrder.withTransportOrder(this.getReference()));
        }
        this.peripheralReservationToken = peripheralReservationToken;
        this.currentDriveOrderIndex = currentDriveOrderIndex;
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
        this.intendedVehicle = intendedVehicle;
        this.deadline = Objects.requireNonNull(deadline, "deadline");
        this.dispensable = dispensable;
        this.wrappingSequence = wrappingSequence;
        this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
        this.processingVehicle = processingVehicle;
        this.state = Objects.requireNonNull(state, "state");
        this.finishedTime = Objects.requireNonNull(finishedTime, "finishedTime");
    }

    public TransportOrder withProperty(String key, String value) {
        return new TransportOrder(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public TransportOrder withProperties(Map<String, String> properties) {
        return new TransportOrder(this.getName(), properties, this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public TransportOrder withHistoryEntry(ObjectHistory.Entry entry) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public TransportOrder withHistory(ObjectHistory history) {
        return new TransportOrder(this.getName(), this.getProperties(), history, this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public String getType() {
        return this.type;
    }

    public TransportOrder withType(String type) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public State getState() {
        return this.state;
    }

    public boolean hasState(State otherState) {
        Objects.requireNonNull(otherState, "otherState");
        return this.state.equals((Object)otherState);
    }

    public TransportOrder withState(@Nonnull State state) {
        return new TransportOrder(this.getName(), this.getProperties(), this.historyForNewState(state), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, state, state == State.FINISHED ? Instant.now() : this.finishedTime);
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public TransportOrder withCreationTime(Instant creationTime) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public TransportOrder withDeadline(Instant deadline) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public Instant getFinishedTime() {
        return this.finishedTime;
    }

    public TransportOrder withFinishedTime(Instant finishedTime) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, finishedTime);
    }

    @Nullable
    public TCSObjectReference<Vehicle> getIntendedVehicle() {
        return this.intendedVehicle;
    }

    public TransportOrder withIntendedVehicle(@Nullable TCSObjectReference<Vehicle> intendedVehicle) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    @Nullable
    public TCSObjectReference<Vehicle> getProcessingVehicle() {
        return this.processingVehicle;
    }

    public TransportOrder withProcessingVehicle(@Nullable TCSObjectReference<Vehicle> processingVehicle) {
        return new TransportOrder(this.getName(), this.getProperties(), this.historyForNewProcessingVehicle(processingVehicle), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, processingVehicle, this.state, this.finishedTime);
    }

    public Set<TCSObjectReference<TransportOrder>> getDependencies() {
        return this.dependencies;
    }

    public TransportOrder withDependencies(@Nonnull Set<TCSObjectReference<TransportOrder>> dependencies) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    @Nonnull
    public List<DriveOrder> getPastDriveOrders() {
        ArrayList<DriveOrder> result = new ArrayList<DriveOrder>();
        for (int i = 0; i < this.currentDriveOrderIndex; ++i) {
            result.add(this.driveOrders.get(i));
        }
        return result;
    }

    @Nonnull
    public List<DriveOrder> getFutureDriveOrders() {
        ArrayList<DriveOrder> result = new ArrayList<DriveOrder>();
        for (int i = this.currentDriveOrderIndex + 1; i < this.driveOrders.size(); ++i) {
            result.add(this.driveOrders.get(i));
        }
        return result;
    }

    public TransportOrder withDriveOrders(@Nonnull List<DriveOrder> driveOrders) {
        Objects.requireNonNull(driveOrders, "driveOrders");
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    @Nullable
    public DriveOrder getCurrentDriveOrder() {
        return this.currentDriveOrderIndex >= 0 && this.currentDriveOrderIndex < this.driveOrders.size() ? this.driveOrders.get(this.currentDriveOrderIndex) : null;
    }

    @Nonnull
    public List<DriveOrder> getAllDriveOrders() {
        return new ArrayList<DriveOrder>(this.driveOrders);
    }

    @Nullable
    public String getPeripheralReservationToken() {
        return this.peripheralReservationToken;
    }

    public TransportOrder withPeripheralReservationToken(@Nullable String peripheralReservationToken) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public int getCurrentDriveOrderIndex() {
        return this.currentDriveOrderIndex;
    }

    public TransportOrder withCurrentDriveOrderIndex(int currentDriveOrderIndex) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public TransportOrder withCurrentDriveOrderState(@Nonnull DriveOrder.State driveOrderState) {
        Objects.requireNonNull(driveOrderState, "driveOrderState");
        ArrayList<DriveOrder> newDriveOrders = new ArrayList<DriveOrder>(this.driveOrders);
        newDriveOrders.set(this.currentDriveOrderIndex, ((DriveOrder)newDriveOrders.get(this.currentDriveOrderIndex)).withState(driveOrderState));
        return new TransportOrder(this.getName(), this.getProperties(), this.historyForNewDriveOrderState(driveOrderState), this.type, newDriveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    @Nullable
    public TCSObjectReference<OrderSequence> getWrappingSequence() {
        return this.wrappingSequence;
    }

    public TransportOrder withWrappingSequence(@Nullable TCSObjectReference<OrderSequence> wrappingSequence) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, this.dispensable, wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    public boolean isDispensable() {
        return this.dispensable;
    }

    public TransportOrder withDispensable(boolean dispensable) {
        return new TransportOrder(this.getName(), this.getProperties(), this.getHistory(), this.type, this.driveOrders, this.peripheralReservationToken, this.currentDriveOrderIndex, this.creationTime, this.intendedVehicle, this.deadline, dispensable, this.wrappingSequence, this.dependencies, this.processingVehicle, this.state, this.finishedTime);
    }

    @Override
    public String toString() {
        return "TransportOrder{name=" + this.getName() + ", state=" + this.state + ", intendedVehicle=" + this.intendedVehicle + ", processingVehicle=" + this.processingVehicle + ", creationTime=" + this.creationTime + ", deadline=" + this.deadline + ", finishedTime=" + this.finishedTime + ", wrappingSequence=" + this.wrappingSequence + ", dispensable=" + this.dispensable + ", type=" + this.type + ", peripheralReservationToken=" + this.peripheralReservationToken + ", dependencies=" + this.dependencies + ", driveOrders=" + this.driveOrders + ", currentDriveOrderIndex=" + this.currentDriveOrderIndex + "}";
    }

    private ObjectHistory historyForNewState(State state) {
        return state.isFinalState() ? this.getHistory().withEntryAppended(new ObjectHistory.Entry("tcsHistory:orderReachedFinalState")) : this.getHistory();
    }

    private ObjectHistory historyForNewDriveOrderState(DriveOrder.State state) {
        return state == DriveOrder.State.FINISHED ? this.getHistory().withEntryAppended(new ObjectHistory.Entry("tcsHistory:orderFinishedDriveOrder")) : this.getHistory();
    }

    private ObjectHistory historyForNewProcessingVehicle(TCSObjectReference<Vehicle> ref) {
        return this.getHistory().withEntryAppended(new ObjectHistory.Entry("tcsHistory:orderProcVehicleChanged", (Object)(ref == null ? "" : ref.getName())));
    }

    public static enum State {
        RAW,
        ACTIVE,
        DISPATCHABLE,
        BEING_PROCESSED,
        WITHDRAWN,
        FINISHED,
        FAILED,
        UNROUTABLE;


        public boolean isFinalState() {
            return this.equals((Object)FINISHED) || this.equals((Object)FAILED) || this.equals((Object)UNROUTABLE);
        }
    }
}

