/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.peripherals.management;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;

public class PeripheralAttachmentInformation
implements Serializable {
    private final TCSResourceReference<Location> locationReference;
    private final List<PeripheralCommAdapterDescription> availableCommAdapters;
    private final PeripheralCommAdapterDescription attachedCommAdapter;

    public PeripheralAttachmentInformation(@Nonnull TCSResourceReference<Location> locationReference, @Nonnull List<PeripheralCommAdapterDescription> availableCommAdapters, @Nonnull PeripheralCommAdapterDescription attachedCommAdapter) {
        this.locationReference = Objects.requireNonNull(locationReference, "locationReference");
        this.availableCommAdapters = Objects.requireNonNull(availableCommAdapters, "availableCommAdapters");
        this.attachedCommAdapter = Objects.requireNonNull(attachedCommAdapter, "attachedCommAdapter");
    }

    @Deprecated
    public PeripheralAttachmentInformation(@Nonnull TCSResourceReference<Location> locationReference, @Nonnull PeripheralCommAdapterDescription attachedCommAdapter) {
        this(locationReference, List.of(), attachedCommAdapter);
    }

    @Nonnull
    public TCSResourceReference<Location> getLocationReference() {
        return this.locationReference;
    }

    public PeripheralAttachmentInformation withLocationReference(TCSResourceReference<Location> locationReference) {
        return new PeripheralAttachmentInformation(locationReference, this.attachedCommAdapter);
    }

    @Nonnull
    public List<PeripheralCommAdapterDescription> getAvailableCommAdapters() {
        return this.availableCommAdapters;
    }

    public PeripheralAttachmentInformation withAvailableCommAdapters(@Nonnull List<PeripheralCommAdapterDescription> availableCommAdapters) {
        return new PeripheralAttachmentInformation(this.locationReference, availableCommAdapters, this.attachedCommAdapter);
    }

    @Nonnull
    public PeripheralCommAdapterDescription getAttachedCommAdapter() {
        return this.attachedCommAdapter;
    }

    public PeripheralAttachmentInformation withAttachedCommAdapter(@Nonnull PeripheralCommAdapterDescription attachedCommAdapter) {
        return new PeripheralAttachmentInformation(this.locationReference, attachedCommAdapter);
    }

    public String toString() {
        return "PeripheralAttachmentInformation{locationReference=" + this.locationReference + ", availableCommAdapters=" + this.availableCommAdapters + ", attachedCommAdapter=" + this.attachedCommAdapter + "}";
    }
}

