/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.components.Lifecycle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.util.ExplainedBoolean;

public interface VehicleCommAdapter
extends Lifecycle {
    public void enable();

    public void disable();

    public boolean isEnabled();

    @Nonnull
    public VehicleProcessModel getProcessModel();

    @Nonnull
    public VehicleProcessModelTO createTransferableProcessModel();

    public int getCommandQueueCapacity();

    @Nonnull
    public Queue<MovementCommand> getCommandQueue();

    default public boolean canAcceptNextCommand() {
        return this.getCommandQueue().size() + this.getSentQueue().size() < this.getCommandQueueCapacity();
    }

    public int getSentQueueCapacity();

    @Nonnull
    public Queue<MovementCommand> getSentQueue();

    public String getRechargeOperation();

    public boolean enqueueCommand(@Nonnull MovementCommand var1);

    public void clearCommandQueue();

    @Nonnull
    default public ExplainedBoolean canProcess(@Nonnull TransportOrder order) {
        return this.canProcess(order.getFutureDriveOrders().stream().map(driveOrder -> driveOrder.getDestination().getOperation()).collect(Collectors.toList()));
    }

    @Nonnull
    @Deprecated
    default public ExplainedBoolean canProcess(@Nonnull List<String> operations) {
        return new ExplainedBoolean(false, "VehicleCommAdapter default implementation");
    }

    default public void onVehiclePaused(boolean paused) {
    }

    public void processMessage(@Nullable Object var1);

    public void execute(@Nonnull AdapterCommand var1);
}

