/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.visualization.LocationRepresentation;

public class LocationCreationTO
extends CreationTO
implements Serializable {
    @Nonnull
    private String typeName;
    @Nonnull
    private Triple position;
    @Nonnull
    private Map<String, Set<String>> links = new HashMap<String, Set<String>>();
    private boolean locked;
    private Layout layout = new Layout();

    public LocationCreationTO(@Nonnull String name, @Nonnull String typeName, @Nonnull Triple position) {
        super(name);
        this.typeName = Objects.requireNonNull(typeName, "typeName");
        this.position = position;
    }

    private LocationCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull String typeName, @Nonnull Triple position, @Nonnull Map<String, Set<String>> links, boolean locked, @Nonnull Layout layout) {
        super(name, properties);
        this.typeName = Objects.requireNonNull(typeName, "typeName");
        this.position = Objects.requireNonNull(position, "position");
        this.links = Objects.requireNonNull(links, "links");
        this.locked = locked;
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public LocationCreationTO withName(@Nonnull String name) {
        return new LocationCreationTO(name, this.getModifiableProperties(), this.typeName, this.position, this.links, this.locked, this.layout);
    }

    @Nonnull
    public String getTypeName() {
        return this.typeName;
    }

    public LocationCreationTO withTypeName(@Nonnull String typeName) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), typeName, this.position, this.links, this.locked, this.layout);
    }

    @Nonnull
    public Triple getPosition() {
        return this.position;
    }

    public LocationCreationTO withPosition(@Nonnull Triple position) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), this.typeName, position, this.links, this.locked, this.layout);
    }

    @Nonnull
    public Map<String, Set<String>> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    public LocationCreationTO withLinks(@Nonnull Map<String, Set<String>> links) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), this.typeName, this.position, links, this.locked, this.layout);
    }

    public LocationCreationTO withLink(@Nonnull String pointName, @Nonnull Set<String> allowedOperations) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), this.typeName, this.position, LocationCreationTO.mapWithMapping(this.links, pointName, allowedOperations), this.locked, this.layout);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public LocationCreationTO withLocked(boolean locked) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), this.typeName, this.position, this.links, locked, this.layout);
    }

    @Override
    public LocationCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new LocationCreationTO(this.getName(), properties, this.typeName, this.position, this.links, this.locked, this.layout);
    }

    @Override
    public LocationCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new LocationCreationTO(this.getName(), this.propertiesWith(key, value), this.typeName, this.position, this.links, this.locked, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public LocationCreationTO withLayout(Layout layout) {
        return new LocationCreationTO(this.getName(), this.getModifiableProperties(), this.typeName, this.position, this.links, this.locked, layout);
    }

    public String toString() {
        return "LocationCreationTO{name=" + this.getName() + ", typeName=" + this.typeName + ", position=" + this.position + ", links=" + this.links + ", locked=" + this.locked + ", layout=" + this.layout + ", properties=" + this.getProperties() + '}';
    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final LocationRepresentation locationRepresentation;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), LocationRepresentation.DEFAULT, 0);
        }

        public Layout(Couple position, Couple labelOffset, LocationRepresentation locationRepresentation, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.locationRepresentation = Objects.requireNonNull(locationRepresentation, "locationRepresentation");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.locationRepresentation, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.locationRepresentation, this.layerId);
        }

        public LocationRepresentation getLocationRepresentation() {
            return this.locationRepresentation;
        }

        public Layout withLocationRepresentation(LocationRepresentation locationRepresentation) {
            return new Layout(this.position, this.labelOffset, locationRepresentation, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, this.locationRepresentation, layerId);
        }

        public String toString() {
            return "Layout{position=" + this.position + ", labelOffset=" + this.labelOffset + ", locationRepresentation=" + (Object)((Object)this.locationRepresentation) + ", layerId=" + this.layerId + '}';
        }
    }
}

