/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.model.ModelLayoutElementCreationTO;
import org.opentcs.access.to.model.ShapeLayoutElementCreationTO;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;

public class VisualLayoutCreationTO
extends CreationTO
implements Serializable {
    private double scaleX = 50.0;
    private double scaleY = 50.0;
    @Deprecated
    private List<ModelLayoutElementCreationTO> modelElements = new LinkedList<ModelLayoutElementCreationTO>();
    @Deprecated
    private List<ShapeLayoutElementCreationTO> shapeElements = new LinkedList<ShapeLayoutElementCreationTO>();
    private List<Layer> layers = new LinkedList<Layer>();
    private List<LayerGroup> layerGroups = new LinkedList<LayerGroup>();

    public VisualLayoutCreationTO(@Nonnull String name) {
        super(name);
    }

    private VisualLayoutCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, double scaleX, double scaleY, @Nonnull List<ModelLayoutElementCreationTO> modelElements, @Nonnull List<ShapeLayoutElementCreationTO> shapeElements, @Nonnull List<Layer> layers, @Nonnull List<LayerGroup> layerGroups) {
        super(name, properties);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.modelElements = Objects.requireNonNull(modelElements, "modelElements");
        this.shapeElements = Objects.requireNonNull(shapeElements, "shapeElements");
        this.layers = Objects.requireNonNull(layers, "layers");
        this.layerGroups = Objects.requireNonNull(layerGroups, "layerGroups");
    }

    @Override
    public VisualLayoutCreationTO withName(@Nonnull String name) {
        return new VisualLayoutCreationTO(name, this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    @Override
    public VisualLayoutCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new VisualLayoutCreationTO(this.getName(), properties, this.scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    @Override
    public VisualLayoutCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new VisualLayoutCreationTO(this.getName(), this.propertiesWith(key, value), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public VisualLayoutCreationTO withScaleX(double scaleX) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public VisualLayoutCreationTO withScaleY(double scaleY) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, scaleY, this.modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    @Deprecated
    @Nonnull
    public List<ModelLayoutElementCreationTO> getModelElements() {
        return Collections.unmodifiableList(this.modelElements);
    }

    @Deprecated
    public VisualLayoutCreationTO withModelElements(@Nonnull List<ModelLayoutElementCreationTO> modelElements) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, modelElements, this.shapeElements, this.layers, this.layerGroups);
    }

    @Deprecated
    public VisualLayoutCreationTO withModelElement(@Nonnull ModelLayoutElementCreationTO modelElement) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, VisualLayoutCreationTO.listWithAppendix(this.modelElements, modelElement), this.shapeElements, this.layers, this.layerGroups);
    }

    @Deprecated
    @Nonnull
    public List<ShapeLayoutElementCreationTO> getShapeElements() {
        return Collections.unmodifiableList(this.shapeElements);
    }

    @Deprecated
    public VisualLayoutCreationTO withShapeElements(@Nonnull List<ShapeLayoutElementCreationTO> shapeElements) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, shapeElements, this.layers, this.layerGroups);
    }

    @Deprecated
    public VisualLayoutCreationTO withShapeElement(@Nonnull ShapeLayoutElementCreationTO shapeElement) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, VisualLayoutCreationTO.listWithAppendix(this.shapeElements, shapeElement), this.layers, this.layerGroups);
    }

    @Nonnull
    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public VisualLayoutCreationTO withLayers(@Nonnull List<Layer> layers) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, layers, this.layerGroups);
    }

    public VisualLayoutCreationTO withLayer(@Nonnull Layer layer) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, VisualLayoutCreationTO.listWithAppendix(this.layers, layer), this.layerGroups);
    }

    @Nonnull
    public List<LayerGroup> getLayerGroups() {
        return Collections.unmodifiableList(this.layerGroups);
    }

    public VisualLayoutCreationTO withLayerGroups(@Nonnull List<LayerGroup> layerGroups) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, layerGroups);
    }

    public VisualLayoutCreationTO withLayerGroup(@Nonnull LayerGroup layerGroup) {
        return new VisualLayoutCreationTO(this.getName(), this.getModifiableProperties(), this.scaleX, this.scaleY, this.modelElements, this.shapeElements, this.layers, VisualLayoutCreationTO.listWithAppendix(this.layerGroups, layerGroup));
    }

    public String toString() {
        return "VisualLayoutCreationTO{name=" + this.getName() + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", modelElements=" + this.modelElements + ", shapeElements=" + this.shapeElements + ", layers=" + this.layers + ", layerGroups=" + this.layerGroups + ", properties=" + this.getProperties() + '}';
    }
}

