/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObjectReference;

public abstract class TCSObject<E extends TCSObject<E>>
implements Serializable {
    protected TCSObjectReference<E> reference;
    private final Map<String, String> properties;
    private final Map<String, String> propertiesReadOnly;
    private final String name;
    private final ObjectHistory history;

    protected TCSObject(@Nonnull String objectName) {
        this(objectName, new HashMap<String, String>(), new ObjectHistory());
    }

    protected TCSObject(@Nonnull String objectName, @Nonnull Map<String, String> properties, @Nonnull ObjectHistory history) {
        this.name = Objects.requireNonNull(objectName, "objectName");
        this.properties = TCSObject.mapWithoutNullValues(properties);
        this.propertiesReadOnly = Collections.unmodifiableMap(this.properties);
        this.reference = new TCSObjectReference(this);
        this.history = Objects.requireNonNull(history, "history");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public TCSObjectReference<E> getReference() {
        return this.reference;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.propertiesReadOnly;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public abstract TCSObject<E> withProperty(String var1, String var2);

    public abstract TCSObject<E> withProperties(Map<String, String> var1);

    public ObjectHistory getHistory() {
        return this.history;
    }

    public abstract TCSObject<E> withHistoryEntry(ObjectHistory.Entry var1);

    public abstract TCSObject<E> withHistory(ObjectHistory var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + '}';
    }

    public boolean equals(Object obj) {
        if (obj instanceof TCSObject) {
            TCSObject other = (TCSObject)obj;
            return this.getName().equals(other.getName()) && this.getClass().equals(other.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getClass().getName().hashCode();
    }

    protected final Map<String, String> propertiesWith(String key, String value) {
        Objects.requireNonNull(key, "key");
        HashMap<String, String> result = new HashMap<String, String>(this.properties);
        if (value == null) {
            result.remove(key);
        } else {
            result.put(key, value);
        }
        return result;
    }

    protected static final <K, V> Map<K, V> mapWithoutNullValues(Map<K, V> original) {
        Objects.requireNonNull(original, "original");
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : original.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected static final <V> List<V> listWithoutNullValues(List<V> original) {
        Objects.requireNonNull(original, "original");
        return original.stream().filter(value -> value != null).collect(Collectors.toList());
    }

    protected static final <V> Set<V> setWithoutNullValues(Set<V> original) {
        Objects.requireNonNull(original, "original");
        return original.stream().filter(value -> value != null).collect(Collectors.toSet());
    }
}

