/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import java.util.Set;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.RemoteTCSObjectServiceProxy;
import org.opentcs.access.rmi.services.RemoteVehicleService;
import org.opentcs.components.kernel.services.VehicleService;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;

class RemoteVehicleServiceProxy
extends RemoteTCSObjectServiceProxy<RemoteVehicleService>
implements VehicleService {
    RemoteVehicleServiceProxy() {
    }

    @Override
    public void attachCommAdapter(TCSObjectReference<Vehicle> ref, VehicleCommAdapterDescription description) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).attachCommAdapter(this.getClientId(), ref, description);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void disableCommAdapter(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).disableCommAdapter(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void enableCommAdapter(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).enableCommAdapter(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public AttachmentInformation fetchAttachmentInformation(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteVehicleService)this.getRemoteService()).fetchAttachmentInformation(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public VehicleProcessModelTO fetchProcessModel(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteVehicleService)this.getRemoteService()).fetchProcessModel(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void sendCommAdapterCommand(TCSObjectReference<Vehicle> ref, AdapterCommand command) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).sendCommAdapterCommand(this.getClientId(), ref, command);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void sendCommAdapterMessage(TCSObjectReference<Vehicle> ref, Object message) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).sendCommAdapterMessage(this.getClientId(), ref, message);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateVehicleIntegrationLevel(TCSObjectReference<Vehicle> ref, Vehicle.IntegrationLevel integrationLevel) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).updateVehicleIntegrationLevel(this.getClientId(), ref, integrationLevel);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateVehiclePaused(TCSObjectReference<Vehicle> ref, boolean paused) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).updateVehiclePaused(this.getClientId(), ref, paused);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateVehicleAllowedOrderTypes(TCSObjectReference<Vehicle> ref, Set<String> allowedOrderTypes) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteVehicleService)this.getRemoteService()).updateVehicleAllowedOrderTypes(this.getClientId(), ref, allowedOrderTypes);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

