/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Triple;
import org.opentcs.util.Assertions;

public class PointCreationTO
extends CreationTO
implements Serializable {
    @Nonnull
    private Triple position = new Triple(0L, 0L, 0L);
    private double vehicleOrientationAngle = Double.NaN;
    @Nonnull
    private Point.Type type = Point.Type.HALT_POSITION;
    private Layout layout = new Layout();

    public PointCreationTO(@Nonnull String name) {
        super(name);
    }

    private PointCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull Triple position, double vehicleOrientationAngle, @Nonnull Point.Type type, @Nonnull Layout layout) {
        super(name, properties);
        this.position = Objects.requireNonNull(position, "position");
        this.vehicleOrientationAngle = vehicleOrientationAngle;
        this.type = Objects.requireNonNull(type, "type");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public PointCreationTO withName(@Nonnull String name) {
        return new PointCreationTO(name, this.getModifiableProperties(), this.position, this.vehicleOrientationAngle, this.type, this.layout);
    }

    @Nonnull
    public Triple getPosition() {
        return this.position;
    }

    public PointCreationTO withPosition(@Nonnull Triple position) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), position, this.vehicleOrientationAngle, this.type, this.layout);
    }

    public double getVehicleOrientationAngle() {
        return this.vehicleOrientationAngle;
    }

    public PointCreationTO withVehicleOrientationAngle(double vehicleOrientationAngle) {
        Assertions.checkArgument(Double.isNaN(vehicleOrientationAngle) || vehicleOrientationAngle >= -360.0 || vehicleOrientationAngle <= 360.0, "vehicleOrientationAngle not in [-360..360]: " + vehicleOrientationAngle);
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.position, vehicleOrientationAngle, this.type, this.layout);
    }

    @Nonnull
    public Point.Type getType() {
        return this.type;
    }

    public PointCreationTO withType(@Nonnull Point.Type type) {
        return new PointCreationTO(this.getName(), this.getProperties(), this.position, this.vehicleOrientationAngle, type, this.layout);
    }

    @Override
    public PointCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PointCreationTO(this.getName(), properties, this.position, this.vehicleOrientationAngle, this.type, this.layout);
    }

    @Override
    public PointCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PointCreationTO(this.getName(), this.propertiesWith(key, value), this.position, this.vehicleOrientationAngle, this.type, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public PointCreationTO withLayout(Layout layout) {
        return new PointCreationTO(this.getName(), this.getModifiableProperties(), this.position, this.vehicleOrientationAngle, this.type, layout);
    }

    public String toString() {
        return "PointCreationTO{name=" + this.getName() + ", position=" + this.position + ", vehicleOrientationAngle=" + this.vehicleOrientationAngle + ", type=" + (Object)((Object)this.type) + ", layout=" + this.layout + ", properties=" + this.getProperties() + '}';
    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), 0);
        }

        public Layout(Couple position, Couple labelOffset, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, layerId);
        }

        public String toString() {
            return "Layout{position=" + this.position + ", labelOffset=" + this.labelOffset + ", layerId=" + this.layerId + '}';
        }
    }
}

