/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data;

import java.io.Serializable;
import java.util.Objects;
import org.opentcs.data.TCSObject;

public class TCSObjectEvent
implements Serializable {
    private final TCSObject<?> currentObjectState;
    private final TCSObject<?> previousObjectState;
    private final Type type;

    public TCSObjectEvent(TCSObject<?> currentObjectState, TCSObject<?> previousObjectState, Type eventType) {
        this.type = Objects.requireNonNull(eventType, "eventType");
        if (currentObjectState == null && !Type.OBJECT_REMOVED.equals((Object)eventType)) {
            throw new IllegalArgumentException("currentObjectState == null but eventType != OBJECT_REMOVED");
        }
        if (previousObjectState == null && !Type.OBJECT_CREATED.equals((Object)eventType)) {
            throw new IllegalArgumentException("previousObjectState == null but eventType != OBJECT_CREATED");
        }
        this.currentObjectState = currentObjectState;
        this.previousObjectState = previousObjectState;
    }

    public TCSObject<?> getCurrentObjectState() {
        return this.currentObjectState;
    }

    public TCSObject<?> getPreviousObjectState() {
        return this.previousObjectState;
    }

    public TCSObject<?> getCurrentOrPreviousObjectState() {
        if (this.currentObjectState != null) {
            return this.currentObjectState;
        }
        return this.previousObjectState;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "TCSObjectEvent{type=" + (Object)((Object)this.type) + ", currentObjectState=" + this.currentObjectState + ", previousObjectState=" + this.previousObjectState + '}';
    }

    public static enum Type {
        OBJECT_CREATED,
        OBJECT_MODIFIED,
        OBJECT_REMOVED;

    }
}

