/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.model.visualization.LocationRepresentation;

public class LocationType
extends TCSObject<LocationType>
implements Serializable {
    private final List<String> allowedOperations;
    private final List<String> allowedPeripheralOperations;
    private final Layout layout;

    public LocationType(String name) {
        super(name);
        this.allowedOperations = new ArrayList<String>();
        this.allowedPeripheralOperations = new ArrayList<String>();
        this.layout = new Layout();
    }

    private LocationType(String name, Map<String, String> properties, ObjectHistory history, List<String> allowedOperations, List<String> allowedPeripheralOperations, Layout layout) {
        super(name, properties, history);
        this.allowedOperations = LocationType.listWithoutNullValues(Objects.requireNonNull(allowedOperations, "allowedOperations"));
        this.allowedPeripheralOperations = LocationType.listWithoutNullValues(Objects.requireNonNull(allowedPeripheralOperations, "allowedPeripheralOperations"));
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public LocationType withProperty(String key, String value) {
        return new LocationType(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    public LocationType withProperties(Map<String, String> properties) {
        return new LocationType(this.getName(), properties, this.getHistory(), this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    @Override
    public TCSObject<LocationType> withHistoryEntry(ObjectHistory.Entry entry) {
        return new LocationType(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    @Override
    public TCSObject<LocationType> withHistory(ObjectHistory history) {
        return new LocationType(this.getName(), this.getProperties(), history, this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    public List<String> getAllowedOperations() {
        return Collections.unmodifiableList(this.allowedOperations);
    }

    public boolean isAllowedOperation(String operation) {
        Objects.requireNonNull(operation, "operation");
        return this.allowedOperations.contains(operation);
    }

    public LocationType withAllowedOperations(List<String> allowedOperations) {
        return new LocationType(this.getName(), this.getProperties(), this.getHistory(), allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    public List<String> getAllowedPeripheralOperations() {
        return Collections.unmodifiableList(this.allowedPeripheralOperations);
    }

    public LocationType withAllowedPeripheralOperations(List<String> allowedPeripheralOperations) {
        return new LocationType(this.getName(), this.getProperties(), this.getHistory(), this.allowedOperations, allowedPeripheralOperations, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public LocationType withLayout(Layout layout) {
        return new LocationType(this.getName(), this.getProperties(), this.getHistory(), this.allowedOperations, this.allowedPeripheralOperations, layout);
    }

    public static class Layout
    implements Serializable {
        private final LocationRepresentation locationRepresentation;

        public Layout() {
            this(LocationRepresentation.NONE);
        }

        public Layout(LocationRepresentation locationRepresentation) {
            this.locationRepresentation = Objects.requireNonNull(locationRepresentation, "locationRepresentation");
        }

        public LocationRepresentation getLocationRepresentation() {
            return this.locationRepresentation;
        }

        public Layout withLocationRepresentation(LocationRepresentation locationRepresentation) {
            return new Layout(locationRepresentation);
        }
    }
}

