/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.util.Assertions;

public class Vehicle
extends TCSObject<Vehicle>
implements Serializable {
    public static final int ROUTE_INDEX_DEFAULT = -1;
    public static final String PREFERRED_ADAPTER = "tcs:preferredAdapterClass";
    private final int length;
    private final int energyLevelGood;
    private final int energyLevelCritical;
    private final int energyLevelFullyRecharged;
    private final int energyLevelSufficientlyRecharged;
    private final int energyLevel;
    private final int maxVelocity;
    private final int maxReverseVelocity;
    private final String rechargeOperation;
    private final List<LoadHandlingDevice> loadHandlingDevices;
    private final State state;
    private final ProcState procState;
    private final IntegrationLevel integrationLevel;
    private final boolean paused;
    private final TCSObjectReference<TransportOrder> transportOrder;
    private final TCSObjectReference<OrderSequence> orderSequence;
    private final Set<String> allowedOrderTypes;
    private final int routeProgressIndex;
    private final List<Set<TCSResourceReference<?>>> claimedResources;
    private final List<Set<TCSResourceReference<?>>> allocatedResources;
    private final TCSObjectReference<Point> currentPosition;
    private final TCSObjectReference<Point> nextPosition;
    private final Triple precisePosition;
    private final double orientationAngle;
    private final Layout layout;

    public Vehicle(String name) {
        super(name);
        this.length = 1000;
        this.energyLevelGood = 90;
        this.energyLevelCritical = 30;
        this.energyLevelFullyRecharged = 90;
        this.energyLevelSufficientlyRecharged = 30;
        this.maxVelocity = 1000;
        this.maxReverseVelocity = 1000;
        this.rechargeOperation = "CHARGE";
        this.procState = ProcState.IDLE;
        this.transportOrder = null;
        this.orderSequence = null;
        this.allowedOrderTypes = new HashSet<String>(Arrays.asList("*"));
        this.routeProgressIndex = -1;
        this.claimedResources = List.of();
        this.allocatedResources = List.of();
        this.state = State.UNKNOWN;
        this.integrationLevel = IntegrationLevel.TO_BE_RESPECTED;
        this.paused = false;
        this.currentPosition = null;
        this.nextPosition = null;
        this.precisePosition = null;
        this.orientationAngle = Double.NaN;
        this.energyLevel = 100;
        this.loadHandlingDevices = new ArrayList<LoadHandlingDevice>();
        this.layout = new Layout();
    }

    private Vehicle(String name, Map<String, String> properties, ObjectHistory history, int length, int energyLevelGood, int energyLevelCritical, int energyLevelFullyRecharged, int energyLevelSufficientlyRecharged, int maxVelocity, int maxReverseVelocity, String rechargeOperation, ProcState procState, TCSObjectReference<TransportOrder> transportOrder, TCSObjectReference<OrderSequence> orderSequence, Set<String> allowedOrderTypes, int routeProgressIndex, List<Set<TCSResourceReference<?>>> claimedResources, List<Set<TCSResourceReference<?>>> allocatedResources, State state, IntegrationLevel integrationLevel, boolean paused, TCSObjectReference<Point> currentPosition, TCSObjectReference<Point> nextPosition, Triple precisePosition, double orientationAngle, int energyLevel, List<LoadHandlingDevice> loadHandlingDevices, Layout layout) {
        super(name, properties, history);
        this.length = Assertions.checkInRange(length, 1, Integer.MAX_VALUE, "length");
        this.energyLevelGood = Assertions.checkInRange(energyLevelGood, 0, 100, "energyLevelGood");
        this.energyLevelCritical = Assertions.checkInRange(energyLevelCritical, 0, 100, "energyLevelCritical");
        this.energyLevelFullyRecharged = Assertions.checkInRange(energyLevelFullyRecharged, 0, 100, "energyLevelFullyRecharged");
        this.energyLevelSufficientlyRecharged = Assertions.checkInRange(energyLevelSufficientlyRecharged, 0, 100, "energyLevelSufficientlyRecharged");
        this.maxVelocity = Assertions.checkInRange(maxVelocity, 0, Integer.MAX_VALUE, "maxVelocity");
        this.maxReverseVelocity = Assertions.checkInRange(maxReverseVelocity, 0, Integer.MAX_VALUE, "maxReverseVelocity");
        this.rechargeOperation = Objects.requireNonNull(rechargeOperation, "rechargeOperation");
        this.procState = Objects.requireNonNull(procState, "procState");
        this.transportOrder = transportOrder;
        this.orderSequence = orderSequence;
        this.allowedOrderTypes = Objects.requireNonNull(allowedOrderTypes, "allowedOrderTypes");
        this.routeProgressIndex = routeProgressIndex;
        this.claimedResources = Objects.requireNonNull(claimedResources, "claimedResources");
        this.allocatedResources = Objects.requireNonNull(allocatedResources, "allocatedResources");
        this.state = Objects.requireNonNull(state, "state");
        this.integrationLevel = Objects.requireNonNull(integrationLevel, "integrationLevel");
        this.paused = paused;
        this.currentPosition = currentPosition;
        this.nextPosition = nextPosition;
        this.precisePosition = precisePosition;
        Assertions.checkArgument(Double.isNaN(orientationAngle) || orientationAngle >= -360.0 && orientationAngle <= 360.0, "Illegal orientation angle: %s", orientationAngle);
        this.orientationAngle = orientationAngle;
        this.energyLevel = Assertions.checkInRange(energyLevel, 0, 100, "energyLevel");
        this.loadHandlingDevices = Vehicle.listWithoutNullValues(Objects.requireNonNull(loadHandlingDevices, "loadHandlingDevices"));
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Vehicle withProperty(String key, String value) {
        return new Vehicle(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public Vehicle withProperties(Map<String, String> properties) {
        return new Vehicle(this.getName(), properties, this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    @Override
    public TCSObject<Vehicle> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    @Override
    public TCSObject<Vehicle> withHistory(ObjectHistory history) {
        return new Vehicle(this.getName(), this.getProperties(), history, this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getEnergyLevel() {
        return this.energyLevel;
    }

    public Vehicle withEnergyLevel(int energyLevel) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, energyLevel, this.loadHandlingDevices, this.layout);
    }

    public boolean isEnergyLevelCritical() {
        return this.energyLevel <= this.energyLevelCritical;
    }

    public boolean isEnergyLevelDegraded() {
        return this.energyLevel <= this.energyLevelGood;
    }

    public boolean isEnergyLevelGood() {
        return this.energyLevel > this.energyLevelGood;
    }

    public boolean isEnergyLevelFullyRecharged() {
        return this.energyLevel >= this.energyLevelFullyRecharged;
    }

    public boolean isEnergyLevelSufficientlyRecharged() {
        return this.energyLevel >= this.energyLevelSufficientlyRecharged;
    }

    public int getEnergyLevelCritical() {
        return this.energyLevelCritical;
    }

    public Vehicle withEnergyLevelCritical(int energyLevelCritical) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getEnergyLevelGood() {
        return this.energyLevelGood;
    }

    public Vehicle withEnergyLevelGood(int energyLevelGood) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getEnergyLevelFullyRecharged() {
        return this.energyLevelFullyRecharged;
    }

    public Vehicle withEnergyLevelFullyRecharged(int energyLevelFullyRecharged) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getEnergyLevelSufficientlyRecharged() {
        return this.energyLevelSufficientlyRecharged;
    }

    public Vehicle withEnergyLevelSufficientlyRecharged(int energyLevelSufficientlyRecharged) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public String getRechargeOperation() {
        return this.rechargeOperation;
    }

    public Vehicle withRechargeOperation(String rechargeOperation) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public List<LoadHandlingDevice> getLoadHandlingDevices() {
        return this.loadHandlingDevices;
    }

    public Vehicle withLoadHandlingDevices(List<LoadHandlingDevice> loadHandlingDevices) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, loadHandlingDevices, this.layout);
    }

    public int getMaxVelocity() {
        return this.maxVelocity;
    }

    public Vehicle withMaxVelocity(int maxVelocity) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getMaxReverseVelocity() {
        return this.maxReverseVelocity;
    }

    public Vehicle withMaxReverseVelocity(int maxReverseVelocity) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public State getState() {
        return this.state;
    }

    public boolean hasState(State otherState) {
        return this.state.equals((Object)otherState);
    }

    public Vehicle withState(State state) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public ProcState getProcState() {
        return this.procState;
    }

    public IntegrationLevel getIntegrationLevel() {
        return this.integrationLevel;
    }

    public Vehicle withIntegrationLevel(IntegrationLevel integrationLevel) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public Vehicle withPaused(boolean paused) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public boolean hasProcState(ProcState otherState) {
        return this.procState.equals((Object)otherState);
    }

    public Vehicle withProcState(ProcState procState) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getLength() {
        return this.length;
    }

    public Vehicle withLength(int length) {
        Assertions.checkInRange(length, 1, Integer.MAX_VALUE, "length");
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public TCSObjectReference<TransportOrder> getTransportOrder() {
        return this.transportOrder;
    }

    public Vehicle withTransportOrder(TCSObjectReference<TransportOrder> transportOrder) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public TCSObjectReference<OrderSequence> getOrderSequence() {
        return this.orderSequence;
    }

    public Vehicle withOrderSequence(TCSObjectReference<OrderSequence> orderSequence) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public Set<String> getAllowedOrderTypes() {
        return this.allowedOrderTypes;
    }

    public Vehicle withAllowedOrderTypes(Set<String> allowedOrderTypes) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public int getRouteProgressIndex() {
        return this.routeProgressIndex;
    }

    public Vehicle withRouteProgressIndex(int routeProgressIndex) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public List<Set<TCSResourceReference<?>>> getClaimedResources() {
        return this.claimedResources;
    }

    public Vehicle withClaimedResources(List<Set<TCSResourceReference<?>>> claimedResources) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public List<Set<TCSResourceReference<?>>> getAllocatedResources() {
        return this.allocatedResources;
    }

    public Vehicle withAllocatedResources(List<Set<TCSResourceReference<?>>> allocatedResources) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public TCSObjectReference<Point> getCurrentPosition() {
        return this.currentPosition;
    }

    public Vehicle withCurrentPosition(TCSObjectReference<Point> currentPosition) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public TCSObjectReference<Point> getNextPosition() {
        return this.nextPosition;
    }

    public Vehicle withNextPosition(TCSObjectReference<Point> nextPosition) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public Triple getPrecisePosition() {
        return this.precisePosition;
    }

    public Vehicle withPrecisePosition(Triple precisePosition) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public double getOrientationAngle() {
        return this.orientationAngle;
    }

    public Vehicle withOrientationAngle(double orientationAngle) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, orientationAngle, this.energyLevel, this.loadHandlingDevices, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Vehicle withLayout(Layout layout) {
        return new Vehicle(this.getName(), this.getProperties(), this.getHistory(), this.length, this.energyLevelGood, this.energyLevelCritical, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.rechargeOperation, this.procState, this.transportOrder, this.orderSequence, this.allowedOrderTypes, this.routeProgressIndex, this.claimedResources, this.allocatedResources, this.state, this.integrationLevel, this.paused, this.currentPosition, this.nextPosition, this.precisePosition, this.orientationAngle, this.energyLevel, this.loadHandlingDevices, layout);
    }

    public boolean isProcessingOrder() {
        return this.transportOrder != null;
    }

    @Override
    public String toString() {
        return "Vehicle{name=" + this.getName() + ", procState=" + (Object)((Object)this.procState) + ", integrationLevel=" + (Object)((Object)this.integrationLevel) + ", paused=" + this.paused + ", state=" + (Object)((Object)this.state) + ", energyLevel=" + this.energyLevel + ", currentPosition=" + this.currentPosition + ", precisePosition=" + this.precisePosition + ", orientationAngle=" + this.orientationAngle + ", nextPosition=" + this.nextPosition + ", loadHandlingDevices=" + this.loadHandlingDevices + ", length=" + this.length + ", transportOrder=" + this.transportOrder + ", routeProgressIndex=" + this.routeProgressIndex + ", claimedResources=" + this.claimedResources + ", allocatedResources=" + this.allocatedResources + ", orderSequence=" + this.orderSequence + ", energyLevelGood=" + this.energyLevelGood + ", energyLevelCritical=" + this.energyLevelCritical + ", energyLevelFullyRecharged=" + this.energyLevelFullyRecharged + ", energyLevelSufficientlyRecharged=" + this.energyLevelSufficientlyRecharged + ", maxVelocity=" + this.maxVelocity + ", maxReverseVelocity=" + this.maxReverseVelocity + ", rechargeOperation=" + this.rechargeOperation + ", allowedOrderTypes=" + this.allowedOrderTypes + '}';
    }

    public static enum ProcState {
        IDLE,
        AWAITING_ORDER,
        PROCESSING_ORDER;

    }

    public static enum State {
        UNKNOWN,
        UNAVAILABLE,
        ERROR,
        IDLE,
        EXECUTING,
        CHARGING;

    }

    public static enum IntegrationLevel {
        TO_BE_IGNORED,
        TO_BE_NOTICED,
        TO_BE_RESPECTED,
        TO_BE_UTILIZED;

    }

    public static class Layout
    implements Serializable {
        private final Color routeColor;

        public Layout() {
            this(Color.RED);
        }

        public Layout(Color routeColor) {
            this.routeColor = Objects.requireNonNull(routeColor, "routeColor");
        }

        public Color getRouteColor() {
            return this.routeColor;
        }

        public Layout withRouteColor(Color routeColor) {
            return new Layout(routeColor);
        }
    }

    public static enum Orientation {
        FORWARD,
        BACKWARD,
        UNDEFINED;

    }
}

