/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.notification;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

public class UserNotification
implements Serializable {
    @Nullable
    private final String source;
    private final String text;
    private final Level level;
    private final Instant timestamp;

    public UserNotification(@Nullable String source, String text, Level level) {
        this.source = source;
        this.text = Objects.requireNonNull(text, "text");
        this.level = Objects.requireNonNull(level, "level");
        this.timestamp = Instant.now();
    }

    public UserNotification(String text, Level level) {
        this(null, text, level);
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    public String getText() {
        return this.text;
    }

    public Level getLevel() {
        return this.level;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.text);
        hash = 89 * hash + Objects.hashCode((Object)this.level);
        hash = 89 * hash + Objects.hashCode(this.timestamp);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UserNotification) {
            UserNotification other = (UserNotification)o;
            return Objects.equals(this.source, other.source) && Objects.equals(this.text, other.text) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.timestamp, other.timestamp);
        }
        return false;
    }

    public String toString() {
        return "UserNotification{source=" + this.source + ", timestamp=" + this.timestamp + ", level=" + (Object)((Object)this.level) + ", text=" + this.text + '}';
    }

    public static enum Level {
        INFORMATIONAL,
        NOTEWORTHY,
        IMPORTANT;

    }
}

