/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.peripherals;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.data.model.TCSResourceReference;

public class PeripheralProcessModel
implements Serializable {
    private final TCSResourceReference<Location> location;
    private final boolean commAdapterEnabled;
    private final boolean commAdapterConnected;
    private final PeripheralInformation.State state;

    public PeripheralProcessModel(TCSResourceReference<Location> location) {
        this(location, false, false, PeripheralInformation.State.NO_PERIPHERAL);
    }

    protected PeripheralProcessModel(@Nonnull TCSResourceReference<Location> location, boolean commAdapterEnabled, boolean commAdapterConnected, @Nonnull PeripheralInformation.State state) {
        this.location = Objects.requireNonNull(location, "location");
        this.commAdapterEnabled = commAdapterEnabled;
        this.commAdapterConnected = commAdapterConnected;
        this.state = Objects.requireNonNull(state, "state");
    }

    @Nonnull
    public TCSResourceReference<Location> getLocation() {
        return this.location;
    }

    public PeripheralProcessModel withLocation(@Nonnull TCSResourceReference<Location> location) {
        return new PeripheralProcessModel(location, this.commAdapterEnabled, this.commAdapterConnected, this.state);
    }

    public boolean isCommAdapterEnabled() {
        return this.commAdapterEnabled;
    }

    public PeripheralProcessModel withCommAdapterEnabled(boolean commAdapterEnabled) {
        return new PeripheralProcessModel(this.location, commAdapterEnabled, this.commAdapterConnected, this.state);
    }

    public boolean isCommAdapterConnected() {
        return this.commAdapterConnected;
    }

    public PeripheralProcessModel withCommAdapterConnected(boolean commAdapterConnected) {
        return new PeripheralProcessModel(this.location, this.commAdapterEnabled, commAdapterConnected, this.state);
    }

    public PeripheralInformation.State getState() {
        return this.state;
    }

    public PeripheralProcessModel withState(PeripheralInformation.State state) {
        return new PeripheralProcessModel(this.location, this.commAdapterEnabled, this.commAdapterConnected, state);
    }

    public static enum Attribute {
        LOCATION,
        COMM_ADAPTER_ENABLED,
        COMM_ADAPTER_CONNECTED,
        STATE;

    }
}

