/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle.commands;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.SimVehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitPositionCommand
implements AdapterCommand {
    private static final Logger LOG = LoggerFactory.getLogger(InitPositionCommand.class);
    private final String position;

    public InitPositionCommand(@Nonnull String position) {
        this.position = Objects.requireNonNull(position, "position");
    }

    @Override
    public void execute(VehicleCommAdapter adapter) {
        if (!(adapter instanceof SimVehicleCommAdapter)) {
            LOG.warn("Adapter is not a SimVehicleCommAdapter: {}", (Object)adapter);
            return;
        }
        ((SimVehicleCommAdapter)adapter).initVehiclePosition(this.position);
    }
}

