/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle.management;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;

public class AttachmentInformation
implements Serializable {
    private final TCSObjectReference<Vehicle> vehicleReference;
    private final List<VehicleCommAdapterDescription> availableCommAdapters;
    private final VehicleCommAdapterDescription attachedCommAdapter;

    public AttachmentInformation(@Nonnull TCSObjectReference<Vehicle> vehicleReference, @Nonnull List<VehicleCommAdapterDescription> availableCommAdapters, @Nonnull VehicleCommAdapterDescription attachedCommAdapter) {
        this.vehicleReference = Objects.requireNonNull(vehicleReference, "vehicleReference");
        this.availableCommAdapters = Objects.requireNonNull(availableCommAdapters, "availableCommAdapters");
        this.attachedCommAdapter = Objects.requireNonNull(attachedCommAdapter, "attachedCommAdapter");
    }

    @Nonnull
    public TCSObjectReference<Vehicle> getVehicleReference() {
        return this.vehicleReference;
    }

    public AttachmentInformation withVehicleReference(TCSObjectReference<Vehicle> vehicleReference) {
        return new AttachmentInformation(vehicleReference, this.availableCommAdapters, this.attachedCommAdapter);
    }

    @Nonnull
    public List<VehicleCommAdapterDescription> getAvailableCommAdapters() {
        return this.availableCommAdapters;
    }

    public AttachmentInformation withAvailableCommAdapters(@Nonnull List<VehicleCommAdapterDescription> availableCommAdapters) {
        return new AttachmentInformation(this.vehicleReference, availableCommAdapters, this.attachedCommAdapter);
    }

    @Nonnull
    public VehicleCommAdapterDescription getAttachedCommAdapter() {
        return this.attachedCommAdapter;
    }

    public AttachmentInformation withAttachedCommAdapter(@Nonnull VehicleCommAdapterDescription attachedCommAdapter) {
        return new AttachmentInformation(this.vehicleReference, this.availableCommAdapters, attachedCommAdapter);
    }
}

