/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CyclicTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CyclicTask.class);
    private final long sleepTime;
    private final Object syncObject = new Object();
    private volatile Thread taskThread;
    private volatile boolean terminated;
    private volatile boolean ignoringInterrupts;

    public CyclicTask(long tSleep) {
        this.sleepTime = Assertions.checkInRange(tSleep, 0L, Long.MAX_VALUE, "tSleep");
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.isTerminated()) {
                LOG.warn("Already terminated");
            }
            this.terminated = true;
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateAndWait() {
        Thread joinThread;
        Object object = this.syncObject;
        synchronized (object) {
            if (this.isTerminated()) {
                LOG.warn("Already terminated");
                return;
            }
            joinThread = this.taskThread;
            this.terminated = true;
            this.syncObject.notify();
        }
        if (joinThread != null && joinThread != Thread.currentThread()) {
            try {
                joinThread.join();
            }
            catch (InterruptedException exc) {
                throw new IllegalStateException("Unexpectedly interrupted", exc);
            }
        }
    }

    public boolean isIgnoringInterrupts() {
        return this.ignoringInterrupts;
    }

    public void setIgnoringInterrupts(boolean ignoreInterrupts) {
        this.ignoringInterrupts = ignoreInterrupts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.debug("method entry");
        this.taskThread = Thread.currentThread();
        while (!this.isTerminated()) {
            LOG.debug("Running actual task...");
            this.runActualTask();
            if (this.isTerminated() || this.sleepTime <= 0L) continue;
            Object object = this.syncObject;
            synchronized (object) {
                block6: {
                    try {
                        this.syncObject.wait(this.sleepTime);
                    }
                    catch (InterruptedException exc) {
                        if (this.isIgnoringInterrupts() && !this.isTerminated()) break block6;
                        LOG.error("Unexpectedly interrupted", (Throwable)exc);
                        throw new IllegalStateException("Unexpectedly interrupted", exc);
                    }
                }
            }
        }
        this.taskThread = null;
        LOG.debug("end of method");
    }

    protected abstract void runActualTask();
}

