/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import java.util.Map;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.RemotePlantModelService;
import org.opentcs.access.rmi.services.RemoteTCSObjectServiceProxy;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.components.kernel.services.PlantModelService;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.PlantModel;

class RemotePlantModelServiceProxy
extends RemoteTCSObjectServiceProxy<RemotePlantModelService>
implements PlantModelService {
    RemotePlantModelServiceProxy() {
    }

    @Override
    public PlantModel getPlantModel() throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemotePlantModelService)this.getRemoteService()).getPlantModel(this.getClientId());
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void createPlantModel(PlantModelCreationTO to) throws ObjectUnknownException, ObjectExistsException, KernelRuntimeException, IllegalStateException {
        this.checkServiceAvailability();
        try {
            ((RemotePlantModelService)this.getRemoteService()).createPlantModel(this.getClientId(), to);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public String getModelName() throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemotePlantModelService)this.getRemoteService()).getModelName(this.getClientId());
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public Map<String, String> getModelProperties() throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemotePlantModelService)this.getRemoteService()).getModelProperties(this.getClientId());
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updateLocationLock(TCSObjectReference<Location> ref, boolean locked) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePlantModelService)this.getRemoteService()).updateLocationLock(this.getClientId(), ref, locked);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void updatePathLock(TCSObjectReference<Path> ref, boolean locked) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePlantModelService)this.getRemoteService()).updatePathLock(this.getClientId(), ref, locked);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

