/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantModelCreationTO
extends CreationTO
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PlantModelCreationTO.class);
    private final List<PointCreationTO> points;
    private final List<PathCreationTO> paths;
    private final List<LocationTypeCreationTO> locationTypes;
    private final List<LocationCreationTO> locations;
    private final List<BlockCreationTO> blocks;
    private final List<VehicleCreationTO> vehicles;
    private final VisualLayoutCreationTO visualLayout;

    public PlantModelCreationTO(String name) {
        super(name);
        this.points = List.of();
        this.paths = List.of();
        this.locationTypes = List.of();
        this.locations = List.of();
        this.blocks = List.of();
        this.vehicles = List.of();
        this.visualLayout = this.defaultVisualLayout();
    }

    private PlantModelCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull List<PointCreationTO> points, @Nonnull List<PathCreationTO> paths, @Nonnull List<LocationTypeCreationTO> locationTypes, @Nonnull List<LocationCreationTO> locations, @Nonnull List<BlockCreationTO> blocks, @Nonnull List<VehicleCreationTO> vehicles, @Nonnull VisualLayoutCreationTO visualLayout) {
        super(name, properties);
        this.points = Objects.requireNonNull(points, "points");
        this.paths = Objects.requireNonNull(paths, "paths");
        this.locationTypes = Objects.requireNonNull(locationTypes, "locationTypes");
        this.locations = Objects.requireNonNull(locations, "locations");
        this.blocks = Objects.requireNonNull(blocks, "blocks");
        this.vehicles = Objects.requireNonNull(vehicles, "vehicles");
        this.visualLayout = Objects.requireNonNull(visualLayout, "visualLayout");
    }

    public List<PointCreationTO> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public PlantModelCreationTO withPoints(@Nonnull List<PointCreationTO> points) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withPoint(@Nonnull PointCreationTO point) {
        Objects.requireNonNull(point, "point");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), PlantModelCreationTO.listWithAppendix(this.points, point), this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public List<PathCreationTO> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public PlantModelCreationTO withPaths(@Nonnull List<PathCreationTO> paths) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withPath(@Nonnull PathCreationTO path) {
        Objects.requireNonNull(path, "path");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, PlantModelCreationTO.listWithAppendix(this.paths, path), this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public List<LocationTypeCreationTO> getLocationTypes() {
        return Collections.unmodifiableList(this.locationTypes);
    }

    public PlantModelCreationTO withLocationTypes(@Nonnull List<LocationTypeCreationTO> locationTypes) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withLocationType(@Nonnull LocationTypeCreationTO locationType) {
        Objects.requireNonNull(locationType, "locationType");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, PlantModelCreationTO.listWithAppendix(this.locationTypes, locationType), this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public List<LocationCreationTO> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public PlantModelCreationTO withLocations(@Nonnull List<LocationCreationTO> locations) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withLocation(@Nonnull LocationCreationTO location) {
        Objects.requireNonNull(location, "location");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, PlantModelCreationTO.listWithAppendix(this.locations, location), this.blocks, this.vehicles, this.visualLayout);
    }

    public List<BlockCreationTO> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public PlantModelCreationTO withBlocks(@Nonnull List<BlockCreationTO> blocks) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, blocks, this.vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withBlock(@Nonnull BlockCreationTO block) {
        Objects.requireNonNull(block, "block");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, CreationTO.listWithAppendix(this.blocks, block), this.vehicles, this.visualLayout);
    }

    public List<VehicleCreationTO> getVehicles() {
        return Collections.unmodifiableList(this.vehicles);
    }

    public PlantModelCreationTO withVehicles(@Nonnull List<VehicleCreationTO> vehicles) {
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, vehicles, this.visualLayout);
    }

    public PlantModelCreationTO withVehicle(@Nonnull VehicleCreationTO vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, PlantModelCreationTO.listWithAppendix(this.vehicles, vehicle), this.visualLayout);
    }

    public VisualLayoutCreationTO getVisualLayout() {
        return this.visualLayout;
    }

    public PlantModelCreationTO withVisualLayout(@Nonnull VisualLayoutCreationTO visualLayout) {
        Objects.requireNonNull(visualLayout, "visualLayout");
        return new PlantModelCreationTO(this.getName(), this.getModifiableProperties(), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.ensureValidity(visualLayout));
    }

    @Override
    public PlantModelCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PlantModelCreationTO(this.getName(), properties, this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Override
    public PlantModelCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PlantModelCreationTO(this.getName(), this.propertiesWith(key, value), this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    public String toString() {
        return "PlantModelCreationTO{name=" + this.getName() + ", points=" + String.valueOf(this.points) + ", paths=" + String.valueOf(this.paths) + ", locationTypes=" + String.valueOf(this.locationTypes) + ", locations=" + String.valueOf(this.locations) + ", blocks=" + String.valueOf(this.blocks) + ", vehicles=" + String.valueOf(this.vehicles) + ", visualLayout=" + String.valueOf(this.visualLayout) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    private VisualLayoutCreationTO defaultVisualLayout() {
        return new VisualLayoutCreationTO("VLayout").withLayer(new Layer(0, 0, true, "Default layer", 0)).withLayerGroup(new LayerGroup(0, "Default layer group", true));
    }

    private VisualLayoutCreationTO ensureValidity(@Nonnull VisualLayoutCreationTO visualLayout) {
        VisualLayoutCreationTO vLayout = visualLayout;
        if (visualLayout.getLayers().isEmpty()) {
            LOG.warn("Adding default layer to visual layout with no layers...");
            vLayout = visualLayout.withLayer(new Layer(0, 0, true, "Default layer", 0));
        }
        if (visualLayout.getLayerGroups().isEmpty()) {
            LOG.warn("Adding default layer group to visual layout with no layer groups...");
            vLayout = vLayout.withLayerGroup(new LayerGroup(0, "Default layer group", true));
        }
        return vLayout;
    }
}

