/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.peripherals;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.peripherals.PeripheralOperation;

public class PeripheralOperationCreationTO
extends CreationTO
implements Serializable {
    private final String operation;
    @Nonnull
    private final String locationName;
    @Nonnull
    private final PeripheralOperation.ExecutionTrigger executionTrigger;
    private final boolean completionRequired;

    public PeripheralOperationCreationTO(@Nonnull String operation, @Nonnull String locationName) {
        super("");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.locationName = Objects.requireNonNull(locationName, "locationName");
        this.executionTrigger = PeripheralOperation.ExecutionTrigger.IMMEDIATE;
        this.completionRequired = false;
    }

    private PeripheralOperationCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull String operation, @Nonnull String locationName, @Nonnull PeripheralOperation.ExecutionTrigger executionTrigger, boolean completionRequired) {
        super(name, properties);
        this.operation = Objects.requireNonNull(operation, "operation");
        this.locationName = Objects.requireNonNull(locationName, "locationName");
        this.executionTrigger = Objects.requireNonNull(executionTrigger, "executionTrigger");
        this.completionRequired = completionRequired;
    }

    @Override
    public PeripheralOperationCreationTO withName(@Nonnull String name) {
        return new PeripheralOperationCreationTO(name, this.getModifiableProperties(), this.operation, this.locationName, this.executionTrigger, this.completionRequired);
    }

    @Override
    public PeripheralOperationCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PeripheralOperationCreationTO(this.getName(), properties, this.operation, this.locationName, this.executionTrigger, this.completionRequired);
    }

    @Override
    public PeripheralOperationCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PeripheralOperationCreationTO(this.getName(), this.propertiesWith(key, value), this.operation, this.locationName, this.executionTrigger, this.completionRequired);
    }

    @Nonnull
    public String getOperation() {
        return this.operation;
    }

    public PeripheralOperationCreationTO withOperation(@Nonnull String operation) {
        return new PeripheralOperationCreationTO(this.getName(), this.getModifiableProperties(), operation, this.locationName, this.executionTrigger, this.completionRequired);
    }

    @Nonnull
    public String getLocationName() {
        return this.locationName;
    }

    public PeripheralOperationCreationTO withLocationName(@Nonnull String locationName) {
        return new PeripheralOperationCreationTO(this.getName(), this.getModifiableProperties(), this.operation, locationName, this.executionTrigger, this.completionRequired);
    }

    @Nonnull
    public PeripheralOperation.ExecutionTrigger getExecutionTrigger() {
        return this.executionTrigger;
    }

    public PeripheralOperationCreationTO withExecutionTrigger(@Nonnull PeripheralOperation.ExecutionTrigger executionTrigger) {
        return new PeripheralOperationCreationTO(this.getName(), this.getModifiableProperties(), this.operation, this.locationName, executionTrigger, this.completionRequired);
    }

    public boolean isCompletionRequired() {
        return this.completionRequired;
    }

    public PeripheralOperationCreationTO withCompletionRequired(boolean completionRequired) {
        return new PeripheralOperationCreationTO(this.getName(), this.getModifiableProperties(), this.operation, this.locationName, this.executionTrigger, completionRequired);
    }
}

