/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.components.kernel.routing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.opentcs.data.model.Path;

public class Edge {
    private final Path path;
    private final boolean travellingReverse;

    public Edge(@Nonnull Path modelPath, boolean travellingReverse) {
        this.path = Objects.requireNonNull(modelPath, "modelPath");
        this.travellingReverse = travellingReverse;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isTravellingReverse() {
        return this.travellingReverse;
    }

    public String getSourceVertex() {
        return this.isTravellingReverse() ? this.path.getDestinationPoint().getName() : this.path.getSourcePoint().getName();
    }

    public String getTargetVertex() {
        return this.isTravellingReverse() ? this.path.getSourcePoint().getName() : this.path.getDestinationPoint().getName();
    }

    public String toString() {
        return "Edge{path=" + String.valueOf(this.path) + ", travellingReverse=" + this.travellingReverse + ", sourceVertex=" + this.getSourceVertex() + ", targetVertex=" + this.getTargetVertex() + "}";
    }
}

