/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.order;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.ReroutingType;
import org.opentcs.util.Assertions;

public class Route
implements Serializable {
    private final List<Step> steps;
    private final long costs;

    public Route(@Nonnull List<Step> routeSteps, long routeCosts) {
        Objects.requireNonNull(routeSteps, "routeSteps");
        Assertions.checkArgument(!routeSteps.isEmpty(), "routeSteps may not be empty");
        this.steps = Collections.unmodifiableList(new ArrayList<Step>(routeSteps));
        this.costs = routeCosts;
    }

    @Nonnull
    public List<Step> getSteps() {
        return this.steps;
    }

    public long getCosts() {
        return this.costs;
    }

    @Nonnull
    public Point getFinalDestinationPoint() {
        return this.steps.get(this.steps.size() - 1).getDestinationPoint();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        return this.costs == other.costs && Objects.equals(this.steps, other.steps);
    }

    public int hashCode() {
        return Objects.hash(this.steps, this.costs);
    }

    public String toString() {
        return "Route{steps=" + String.valueOf(this.steps) + ", costs=" + this.costs + "}";
    }

    public static class Step
    implements Serializable {
        private final Path path;
        private final Point sourcePoint;
        private final Point destinationPoint;
        private final Vehicle.Orientation vehicleOrientation;
        private final int routeIndex;
        private final boolean executionAllowed;
        private final ReroutingType reroutingType;

        public Step(@Nullable Path path, @Nullable Point srcPoint, @Nonnull Point destPoint, @Nonnull Vehicle.Orientation orientation, int routeIndex, boolean executionAllowed, @Nullable ReroutingType reroutingType) {
            this.path = path;
            this.sourcePoint = srcPoint;
            this.destinationPoint = Objects.requireNonNull(destPoint, "destPoint");
            this.vehicleOrientation = Objects.requireNonNull(orientation, "orientation");
            this.routeIndex = routeIndex;
            this.executionAllowed = executionAllowed;
            this.reroutingType = reroutingType;
        }

        public Step(@Nullable Path path, @Nullable Point srcPoint, @Nonnull Point destPoint, @Nonnull Vehicle.Orientation orientation, int routeIndex, boolean executionAllowed) {
            this(path, srcPoint, destPoint, orientation, routeIndex, executionAllowed, null);
        }

        public Step(@Nullable Path path, @Nullable Point srcPoint, @Nonnull Point destPoint, @Nonnull Vehicle.Orientation orientation, int routeIndex) {
            this(path, srcPoint, destPoint, orientation, routeIndex, true, null);
        }

        @Nullable
        public Path getPath() {
            return this.path;
        }

        @Nullable
        public Point getSourcePoint() {
            return this.sourcePoint;
        }

        @Nonnull
        public Point getDestinationPoint() {
            return this.destinationPoint;
        }

        @Nonnull
        public Vehicle.Orientation getVehicleOrientation() {
            return this.vehicleOrientation;
        }

        public int getRouteIndex() {
            return this.routeIndex;
        }

        public boolean isExecutionAllowed() {
            return this.executionAllowed;
        }

        @Nullable
        public ReroutingType getReroutingType() {
            return this.reroutingType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            return Objects.equals(this.path, other.path) && Objects.equals(this.sourcePoint, other.sourcePoint) && Objects.equals(this.destinationPoint, other.destinationPoint) && Objects.equals((Object)this.vehicleOrientation, (Object)other.vehicleOrientation) && this.routeIndex == other.routeIndex && this.executionAllowed == other.executionAllowed && this.reroutingType == other.reroutingType;
        }

        public boolean equalsInMovement(Step step) {
            if (step == null) {
                return false;
            }
            return Objects.equals(this.getSourcePoint(), step.getSourcePoint()) && Objects.equals(this.getDestinationPoint(), step.getDestinationPoint()) && Objects.equals(this.getPath(), step.getPath()) && Objects.equals((Object)this.getVehicleOrientation(), (Object)step.getVehicleOrientation()) && Objects.equals(this.getRouteIndex(), step.getRouteIndex());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.path, this.sourcePoint, this.destinationPoint, this.vehicleOrientation, this.routeIndex, this.executionAllowed, this.reroutingType});
        }

        public String toString() {
            return this.destinationPoint.getName();
        }
    }
}

